// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseMetadataSyncConfigurationResource
    {
        // Get metadata sync config for a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetMetadataSyncConfigForASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolMetadataSyncConfig.json
            // this example is just showing the usage of "SqlPoolMetadataSyncConfigs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseMetadataSyncConfigurationResource created on azure
            // for more information of creating SynapseMetadataSyncConfigurationResource, please refer to the document of SynapseMetadataSyncConfigurationResource
            string subscriptionId = "01234567-89ab-4def-0123-456789abcdef";
            string resourceGroupName = "ExampleResourceGroup";
            string workspaceName = "ExampleWorkspace";
            string sqlPoolName = "ExampleSqlPool";
            ResourceIdentifier synapseMetadataSyncConfigurationResourceId = SynapseMetadataSyncConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseMetadataSyncConfigurationResource synapseMetadataSyncConfiguration = client.GetSynapseMetadataSyncConfigurationResource(synapseMetadataSyncConfigurationResourceId);

            // invoke the operation
            SynapseMetadataSyncConfigurationResource result = await synapseMetadataSyncConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseMetadataSyncConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Set metadata sync config for a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SetMetadataSyncConfigForASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateSqlPoolMetadataSyncConfig.json
            // this example is just showing the usage of "SqlPoolMetadataSyncConfigs_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseMetadataSyncConfigurationResource created on azure
            // for more information of creating SynapseMetadataSyncConfigurationResource, please refer to the document of SynapseMetadataSyncConfigurationResource
            string subscriptionId = "01234567-89ab-4def-0123-456789abcdef";
            string resourceGroupName = "ExampleResourceGroup";
            string workspaceName = "ExampleWorkspace";
            string sqlPoolName = "ExampleSqlPool";
            ResourceIdentifier synapseMetadataSyncConfigurationResourceId = SynapseMetadataSyncConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseMetadataSyncConfigurationResource synapseMetadataSyncConfiguration = client.GetSynapseMetadataSyncConfigurationResource(synapseMetadataSyncConfigurationResourceId);

            // invoke the operation
            SynapseMetadataSyncConfigurationData data = new SynapseMetadataSyncConfigurationData()
            {
                IsEnabled = true,
            };
            ArmOperation<SynapseMetadataSyncConfigurationResource> lro = await synapseMetadataSyncConfiguration.CreateOrUpdateAsync(WaitUntil.Completed, data);
            SynapseMetadataSyncConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseMetadataSyncConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
