// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseDedicatedSqlMinimalTlsSettingCollection
    {
        // Get workspace managed sql server dedicated sql minimal tls settings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetWorkspaceManagedSqlServerDedicatedSqlMinimalTlsSettings()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerDedicatedSQLminimalTlsSettings.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "workspace-6852";
            string workspaceName = "workspace-2080";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseDedicatedSqlMinimalTlsSettingResource
            SynapseDedicatedSqlMinimalTlsSettingCollection collection = synapseWorkspace.GetSynapseDedicatedSqlMinimalTlsSettings();

            // invoke the operation
            string dedicatedSQLminimalTlsSettingsName = "default";
            SynapseDedicatedSqlMinimalTlsSettingResource result = await collection.GetAsync(dedicatedSQLminimalTlsSettingsName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseDedicatedSqlMinimalTlsSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get workspace managed sql server dedicated sql minimal tls settings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetWorkspaceManagedSqlServerDedicatedSqlMinimalTlsSettings()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerDedicatedSQLminimalTlsSettings.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "workspace-6852";
            string workspaceName = "workspace-2080";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseDedicatedSqlMinimalTlsSettingResource
            SynapseDedicatedSqlMinimalTlsSettingCollection collection = synapseWorkspace.GetSynapseDedicatedSqlMinimalTlsSettings();

            // invoke the operation
            string dedicatedSQLminimalTlsSettingsName = "default";
            bool result = await collection.ExistsAsync(dedicatedSQLminimalTlsSettingsName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get workspace managed sql server dedicated sql minimal tls settings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetWorkspaceManagedSqlServerDedicatedSqlMinimalTlsSettings()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerDedicatedSQLminimalTlsSettings.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "workspace-6852";
            string workspaceName = "workspace-2080";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseDedicatedSqlMinimalTlsSettingResource
            SynapseDedicatedSqlMinimalTlsSettingCollection collection = synapseWorkspace.GetSynapseDedicatedSqlMinimalTlsSettings();

            // invoke the operation
            string dedicatedSQLminimalTlsSettingsName = "default";
            NullableResponse<SynapseDedicatedSqlMinimalTlsSettingResource> response = await collection.GetIfExistsAsync(dedicatedSQLminimalTlsSettingsName);
            SynapseDedicatedSqlMinimalTlsSettingResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseDedicatedSqlMinimalTlsSettingData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List dedicated sql minimal tls settings of the workspace managed sql server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListDedicatedSqlMinimalTlsSettingsOfTheWorkspaceManagedSqlServer()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListWorkspaceManagedSqlServerDedicatedSQLminimalTlsSettings.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "workspace-6852";
            string workspaceName = "workspace-2080";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseDedicatedSqlMinimalTlsSettingResource
            SynapseDedicatedSqlMinimalTlsSettingCollection collection = synapseWorkspace.GetSynapseDedicatedSqlMinimalTlsSettings();

            // invoke the operation and iterate over the result
            await foreach (SynapseDedicatedSqlMinimalTlsSettingResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseDedicatedSqlMinimalTlsSettingData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
