// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseDataMaskingRuleResource
    {
        // Create/Update data masking rule for default max
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateUpdateDataMaskingRuleForDefaultMax()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateDefaultMax.json
            // this example is just showing the usage of "DataMaskingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseDataMaskingRuleResource created on azure
            // for more information of creating SynapseDataMaskingRuleResource, please refer to the document of SynapseDataMaskingRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-6852";
            string workspaceName = "sqlcrudtest-2080";
            string sqlPoolName = "sqlcrudtest-331";
            string dataMaskingRuleName = "rule1";
            ResourceIdentifier synapseDataMaskingRuleResourceId = SynapseDataMaskingRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, dataMaskingRuleName);
            SynapseDataMaskingRuleResource synapseDataMaskingRule = client.GetSynapseDataMaskingRuleResource(synapseDataMaskingRuleResourceId);

            // invoke the operation
            SynapseDataMaskingRuleData data = new SynapseDataMaskingRuleData()
            {
                AliasName = "nickname",
                RuleState = SynapseDataMaskingRuleState.Enabled,
                SchemaName = "dbo",
                TableName = "Table_1",
                ColumnName = "test1",
                MaskingFunction = SynapseDataMaskingFunction.Default,
            };
            ArmOperation<SynapseDataMaskingRuleResource> lro = await synapseDataMaskingRule.UpdateAsync(WaitUntil.Completed, data);
            SynapseDataMaskingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseDataMaskingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update data masking rule for default min
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateUpdateDataMaskingRuleForDefaultMin()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateDefaultMin.json
            // this example is just showing the usage of "DataMaskingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseDataMaskingRuleResource created on azure
            // for more information of creating SynapseDataMaskingRuleResource, please refer to the document of SynapseDataMaskingRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-6852";
            string workspaceName = "sqlcrudtest-2080";
            string sqlPoolName = "sqlcrudtest-331";
            string dataMaskingRuleName = "rule1";
            ResourceIdentifier synapseDataMaskingRuleResourceId = SynapseDataMaskingRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, dataMaskingRuleName);
            SynapseDataMaskingRuleResource synapseDataMaskingRule = client.GetSynapseDataMaskingRuleResource(synapseDataMaskingRuleResourceId);

            // invoke the operation
            SynapseDataMaskingRuleData data = new SynapseDataMaskingRuleData()
            {
                SchemaName = "dbo",
                TableName = "Table_1",
                ColumnName = "test1",
                MaskingFunction = SynapseDataMaskingFunction.Default,
            };
            ArmOperation<SynapseDataMaskingRuleResource> lro = await synapseDataMaskingRule.UpdateAsync(WaitUntil.Completed, data);
            SynapseDataMaskingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseDataMaskingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update data masking rule for numbers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateUpdateDataMaskingRuleForNumbers()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateNumber.json
            // this example is just showing the usage of "DataMaskingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseDataMaskingRuleResource created on azure
            // for more information of creating SynapseDataMaskingRuleResource, please refer to the document of SynapseDataMaskingRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-6852";
            string workspaceName = "sqlcrudtest-2080";
            string sqlPoolName = "sqlcrudtest-331";
            string dataMaskingRuleName = "rule1";
            ResourceIdentifier synapseDataMaskingRuleResourceId = SynapseDataMaskingRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, dataMaskingRuleName);
            SynapseDataMaskingRuleResource synapseDataMaskingRule = client.GetSynapseDataMaskingRuleResource(synapseDataMaskingRuleResourceId);

            // invoke the operation
            SynapseDataMaskingRuleData data = new SynapseDataMaskingRuleData()
            {
                SchemaName = "dbo",
                TableName = "Table_1",
                ColumnName = "test1",
                MaskingFunction = SynapseDataMaskingFunction.Number,
                NumberFrom = "0",
                NumberTo = "2",
            };
            ArmOperation<SynapseDataMaskingRuleResource> lro = await synapseDataMaskingRule.UpdateAsync(WaitUntil.Completed, data);
            SynapseDataMaskingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseDataMaskingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update data masking rule for text
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateUpdateDataMaskingRuleForText()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateText.json
            // this example is just showing the usage of "DataMaskingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseDataMaskingRuleResource created on azure
            // for more information of creating SynapseDataMaskingRuleResource, please refer to the document of SynapseDataMaskingRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-6852";
            string workspaceName = "sqlcrudtest-2080";
            string sqlPoolName = "sqlcrudtest-331";
            string dataMaskingRuleName = "rule1";
            ResourceIdentifier synapseDataMaskingRuleResourceId = SynapseDataMaskingRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, dataMaskingRuleName);
            SynapseDataMaskingRuleResource synapseDataMaskingRule = client.GetSynapseDataMaskingRuleResource(synapseDataMaskingRuleResourceId);

            // invoke the operation
            SynapseDataMaskingRuleData data = new SynapseDataMaskingRuleData()
            {
                SchemaName = "dbo",
                TableName = "Table_1",
                ColumnName = "test1",
                MaskingFunction = SynapseDataMaskingFunction.Text,
                PrefixSize = "1",
                SuffixSize = "0",
                ReplacementString = "asdf",
            };
            ArmOperation<SynapseDataMaskingRuleResource> lro = await synapseDataMaskingRule.UpdateAsync(WaitUntil.Completed, data);
            SynapseDataMaskingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseDataMaskingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get data masking rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDataMaskingRule()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleGet.json
            // this example is just showing the usage of "DataMaskingRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseDataMaskingRuleResource created on azure
            // for more information of creating SynapseDataMaskingRuleResource, please refer to the document of SynapseDataMaskingRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-6852";
            string workspaceName = "sqlcrudtest-2080";
            string sqlPoolName = "sqlcrudtest-331";
            string dataMaskingRuleName = "rule1";
            ResourceIdentifier synapseDataMaskingRuleResourceId = SynapseDataMaskingRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, dataMaskingRuleName);
            SynapseDataMaskingRuleResource synapseDataMaskingRule = client.GetSynapseDataMaskingRuleResource(synapseDataMaskingRuleResourceId);

            // invoke the operation
            SynapseDataMaskingRuleResource result = await synapseDataMaskingRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseDataMaskingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
