// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Analytics.Synapse.Spark.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Synapse.Spark
{
    /// <summary> The SparkSession service client. </summary>
    public partial class SparkSessionClient
    {
        private readonly ClientDiagnostics _clientDiagnostics;
        private readonly HttpPipeline _pipeline;
        internal SparkSessionRestClient RestClient { get; }

        /// <summary> Initializes a new instance of SparkSessionClient for mocking. </summary>
        protected SparkSessionClient()
        {
        }

        /// <summary> Initializes a new instance of SparkSessionClient. </summary>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        /// <param name="livyApiVersion"> Valid api-version for the request. The default value is "2019-11-01-preview". </param>
        /// <param name="sparkPoolName"> Name of the spark pool. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        public SparkSessionClient(Uri endpoint, string livyApiVersion, string sparkPoolName, TokenCredential credential, SparkClientOptions options = null)
        {
            if (endpoint == null)
            {
                throw new ArgumentNullException(nameof(endpoint));
            }
            if (livyApiVersion == null)
            {
                throw new ArgumentNullException(nameof(livyApiVersion));
            }
            if (sparkPoolName == null)
            {
                throw new ArgumentNullException(nameof(sparkPoolName));
            }
            if (credential == null)
            {
                throw new ArgumentNullException(nameof(credential));
            }

            options ??= new SparkClientOptions();
            _clientDiagnostics = new ClientDiagnostics(options);
            string[] scopes = { "https://dev.azuresynapse.net/.default" };
            _pipeline = HttpPipelineBuilder.Build(options, new BearerTokenAuthenticationPolicy(credential, scopes));
            RestClient = new SparkSessionRestClient(_clientDiagnostics, _pipeline, endpoint, livyApiVersion, sparkPoolName);
        }

        /// <summary> Initializes a new instance of SparkSessionClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        /// <param name="livyApiVersion"> Valid api-version for the request. The default value is "2019-11-01-preview". </param>
        /// <param name="sparkPoolName"> Name of the spark pool. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/>, <paramref name="livyApiVersion"/> or <paramref name="sparkPoolName"/> is null. </exception>
        internal SparkSessionClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint, string livyApiVersion, string sparkPoolName)
        {
            RestClient = new SparkSessionRestClient(clientDiagnostics, pipeline, endpoint, livyApiVersion, sparkPoolName);
            _clientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
        }

        /// <summary> List all spark sessions which are running under a particular spark pool. </summary>
        /// <param name="from"> Optional param specifying which index the list should begin from. </param>
        /// <param name="size">
        /// Optional param specifying the size of the returned list.
        ///             By default it is 20 and that is the maximum.
        /// </param>
        /// <param name="detailed"> Optional query param specifying whether detailed response is returned beyond plain livy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SparkSessionCollection>> GetSparkSessionsAsync(int? @from = null, int? size = null, bool? detailed = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkSessions");
            scope.Start();
            try
            {
                return await RestClient.GetSparkSessionsAsync(@from, size, detailed, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> List all spark sessions which are running under a particular spark pool. </summary>
        /// <param name="from"> Optional param specifying which index the list should begin from. </param>
        /// <param name="size">
        /// Optional param specifying the size of the returned list.
        ///             By default it is 20 and that is the maximum.
        /// </param>
        /// <param name="detailed"> Optional query param specifying whether detailed response is returned beyond plain livy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SparkSessionCollection> GetSparkSessions(int? @from = null, int? size = null, bool? detailed = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkSessions");
            scope.Start();
            try
            {
                return RestClient.GetSparkSessions(@from, size, detailed, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets a single spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="detailed"> Optional query param specifying whether detailed response is returned beyond plain livy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SparkSession>> GetSparkSessionAsync(int sessionId, bool? detailed = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkSession");
            scope.Start();
            try
            {
                return await RestClient.GetSparkSessionAsync(sessionId, detailed, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets a single spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="detailed"> Optional query param specifying whether detailed response is returned beyond plain livy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SparkSession> GetSparkSession(int sessionId, bool? detailed = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkSession");
            scope.Start();
            try
            {
                return RestClient.GetSparkSession(sessionId, detailed, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Cancels a running spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> CancelSparkSessionAsync(int sessionId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.CancelSparkSession");
            scope.Start();
            try
            {
                return await RestClient.CancelSparkSessionAsync(sessionId, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Cancels a running spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response CancelSparkSession(int sessionId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.CancelSparkSession");
            scope.Start();
            try
            {
                return RestClient.CancelSparkSession(sessionId, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Sends a keep alive call to the current session to reset the session timeout. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> ResetSparkSessionTimeoutAsync(int sessionId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.ResetSparkSessionTimeout");
            scope.Start();
            try
            {
                return await RestClient.ResetSparkSessionTimeoutAsync(sessionId, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Sends a keep alive call to the current session to reset the session timeout. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response ResetSparkSessionTimeout(int sessionId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.ResetSparkSessionTimeout");
            scope.Start();
            try
            {
                return RestClient.ResetSparkSessionTimeout(sessionId, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets a list of statements within a spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SparkStatementCollection>> GetSparkStatementsAsync(int sessionId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkStatements");
            scope.Start();
            try
            {
                return await RestClient.GetSparkStatementsAsync(sessionId, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets a list of statements within a spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SparkStatementCollection> GetSparkStatements(int sessionId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkStatements");
            scope.Start();
            try
            {
                return RestClient.GetSparkStatements(sessionId, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets a single statement within a spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="statementId"> Identifier for the statement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SparkStatement>> GetSparkStatementAsync(int sessionId, int statementId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkStatement");
            scope.Start();
            try
            {
                return await RestClient.GetSparkStatementAsync(sessionId, statementId, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets a single statement within a spark session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="statementId"> Identifier for the statement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SparkStatement> GetSparkStatement(int sessionId, int statementId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.GetSparkStatement");
            scope.Start();
            try
            {
                return RestClient.GetSparkStatement(sessionId, statementId, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Kill a statement within a session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="statementId"> Identifier for the statement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SparkStatementCancellationResult>> CancelSparkStatementAsync(int sessionId, int statementId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.CancelSparkStatement");
            scope.Start();
            try
            {
                return await RestClient.CancelSparkStatementAsync(sessionId, statementId, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Kill a statement within a session. </summary>
        /// <param name="sessionId"> Identifier for the session. </param>
        /// <param name="statementId"> Identifier for the statement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SparkStatementCancellationResult> CancelSparkStatement(int sessionId, int statementId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("SparkSessionClient.CancelSparkStatement");
            scope.Start();
            try
            {
                return RestClient.CancelSparkStatement(sessionId, statementId, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
