// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Analytics.Synapse.Spark.Models
{
    public partial class SparkStatementOutput
    {
        internal static SparkStatementOutput DeserializeSparkStatementOutput(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string status = default;
            int executionCount = default;
            object data = default;
            string ename = default;
            string evalue = default;
            IReadOnlyList<string> traceback = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("execution_count"u8))
                {
                    executionCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("data"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    data = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("ename"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        ename = null;
                        continue;
                    }
                    ename = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("evalue"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        evalue = null;
                        continue;
                    }
                    evalue = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("traceback"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    traceback = array;
                    continue;
                }
            }
            return new SparkStatementOutput(
                status,
                executionCount,
                data,
                ename,
                evalue,
                traceback ?? new ChangeTrackingList<string>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SparkStatementOutput FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSparkStatementOutput(document.RootElement);
        }
    }
}
