// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Analytics.Synapse.Spark.Models
{
    public partial class SparkStatementCancellationResult
    {
        internal static SparkStatementCancellationResult DeserializeSparkStatementCancellationResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string msg = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("msg"u8))
                {
                    msg = property.Value.GetString();
                    continue;
                }
            }
            return new SparkStatementCancellationResult(msg);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SparkStatementCancellationResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSparkStatementCancellationResult(document.RootElement);
        }
    }
}
