// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Spark.Models
{
    /// <summary> The SparkSessionCollection. </summary>
    public partial class SparkSessionCollection
    {
        /// <summary> Initializes a new instance of <see cref="SparkSessionCollection"/>. </summary>
        /// <param name="from"></param>
        /// <param name="total"></param>
        internal SparkSessionCollection(int @from, int total)
        {
            From = @from;
            Total = total;
            Sessions = new ChangeTrackingList<SparkSession>();
        }

        /// <summary> Initializes a new instance of <see cref="SparkSessionCollection"/>. </summary>
        /// <param name="from"></param>
        /// <param name="total"></param>
        /// <param name="sessions"></param>
        internal SparkSessionCollection(int @from, int total, IReadOnlyList<SparkSession> sessions)
        {
            From = @from;
            Total = total;
            Sessions = sessions;
        }

        /// <summary> Gets the from. </summary>
        public int From { get; }
        /// <summary> Gets the total. </summary>
        public int Total { get; }
        /// <summary> Gets the sessions. </summary>
        public IReadOnlyList<SparkSession> Sessions { get; }
    }
}
