// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Spark.Models
{
    /// <summary> Response for batch list operation. </summary>
    public partial class SparkBatchJobCollection
    {
        /// <summary> Initializes a new instance of <see cref="SparkBatchJobCollection"/>. </summary>
        /// <param name="from"> The start index of fetched sessions. </param>
        /// <param name="total"> Number of sessions fetched. </param>
        internal SparkBatchJobCollection(int @from, int total)
        {
            From = @from;
            Total = total;
            Sessions = new ChangeTrackingList<SparkBatchJob>();
        }

        /// <summary> Initializes a new instance of <see cref="SparkBatchJobCollection"/>. </summary>
        /// <param name="from"> The start index of fetched sessions. </param>
        /// <param name="total"> Number of sessions fetched. </param>
        /// <param name="sessions"> Batch list. </param>
        internal SparkBatchJobCollection(int @from, int total, IReadOnlyList<SparkBatchJob> sessions)
        {
            From = @from;
            Total = total;
            Sessions = sessions;
        }

        /// <summary> The start index of fetched sessions. </summary>
        public int From { get; }
        /// <summary> Number of sessions fetched. </summary>
        public int Total { get; }
        /// <summary> Batch list. </summary>
        public IReadOnlyList<SparkBatchJob> Sessions { get; }
    }
}
