// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Spark.Models
{
    /// <summary> The PluginCurrentState. </summary>
    public readonly partial struct PluginCurrentState : IEquatable<PluginCurrentState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PluginCurrentState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PluginCurrentState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreparationValue = "Preparation";
        private const string ResourceAcquisitionValue = "ResourceAcquisition";
        private const string QueuedValue = "Queued";
        private const string SubmissionValue = "Submission";
        private const string MonitoringValue = "Monitoring";
        private const string CleanupValue = "Cleanup";
        private const string EndedValue = "Ended";

        /// <summary> Preparation. </summary>
        public static PluginCurrentState Preparation { get; } = new PluginCurrentState(PreparationValue);
        /// <summary> ResourceAcquisition. </summary>
        public static PluginCurrentState ResourceAcquisition { get; } = new PluginCurrentState(ResourceAcquisitionValue);
        /// <summary> Queued. </summary>
        public static PluginCurrentState Queued { get; } = new PluginCurrentState(QueuedValue);
        /// <summary> Submission. </summary>
        public static PluginCurrentState Submission { get; } = new PluginCurrentState(SubmissionValue);
        /// <summary> Monitoring. </summary>
        public static PluginCurrentState Monitoring { get; } = new PluginCurrentState(MonitoringValue);
        /// <summary> Cleanup. </summary>
        public static PluginCurrentState Cleanup { get; } = new PluginCurrentState(CleanupValue);
        /// <summary> Ended. </summary>
        public static PluginCurrentState Ended { get; } = new PluginCurrentState(EndedValue);
        /// <summary> Determines if two <see cref="PluginCurrentState"/> values are the same. </summary>
        public static bool operator ==(PluginCurrentState left, PluginCurrentState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PluginCurrentState"/> values are not the same. </summary>
        public static bool operator !=(PluginCurrentState left, PluginCurrentState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PluginCurrentState"/>. </summary>
        public static implicit operator PluginCurrentState(string value) => new PluginCurrentState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PluginCurrentState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PluginCurrentState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
