// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Spark.Models
{
    /// <summary> The LivyStatementStates. </summary>
    public readonly partial struct LivyStatementStates : IEquatable<LivyStatementStates>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LivyStatementStates"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LivyStatementStates(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WaitingValue = "waiting";
        private const string RunningValue = "running";
        private const string AvailableValue = "available";
        private const string ErrorValue = "error";
        private const string CancellingValue = "cancelling";
        private const string CancelledValue = "cancelled";

        /// <summary> waiting. </summary>
        public static LivyStatementStates Waiting { get; } = new LivyStatementStates(WaitingValue);
        /// <summary> running. </summary>
        public static LivyStatementStates Running { get; } = new LivyStatementStates(RunningValue);
        /// <summary> available. </summary>
        public static LivyStatementStates Available { get; } = new LivyStatementStates(AvailableValue);
        /// <summary> error. </summary>
        public static LivyStatementStates Error { get; } = new LivyStatementStates(ErrorValue);
        /// <summary> cancelling. </summary>
        public static LivyStatementStates Cancelling { get; } = new LivyStatementStates(CancellingValue);
        /// <summary> cancelled. </summary>
        public static LivyStatementStates Cancelled { get; } = new LivyStatementStates(CancelledValue);
        /// <summary> Determines if two <see cref="LivyStatementStates"/> values are the same. </summary>
        public static bool operator ==(LivyStatementStates left, LivyStatementStates right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LivyStatementStates"/> values are not the same. </summary>
        public static bool operator !=(LivyStatementStates left, LivyStatementStates right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LivyStatementStates"/>. </summary>
        public static implicit operator LivyStatementStates(string value) => new LivyStatementStates(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LivyStatementStates other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LivyStatementStates other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
