// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Spark.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class AnalyticsSynapseSparkModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.SparkBatchJobCollection"/>. </summary>
        /// <param name="from"> The start index of fetched sessions. </param>
        /// <param name="total"> Number of sessions fetched. </param>
        /// <param name="sessions"> Batch list. </param>
        /// <returns> A new <see cref="Models.SparkBatchJobCollection"/> instance for mocking. </returns>
        public static SparkBatchJobCollection SparkBatchJobCollection(int @from = default, int total = default, IEnumerable<SparkBatchJob> sessions = null)
        {
            sessions ??= new List<SparkBatchJob>();

            return new SparkBatchJobCollection(@from, total, sessions?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkBatchJob"/>. </summary>
        /// <param name="livyInfo"></param>
        /// <param name="name"> The batch name. </param>
        /// <param name="workspaceName"> The workspace name. </param>
        /// <param name="sparkPoolName"> The Spark pool name. </param>
        /// <param name="submitterName"> The submitter name. </param>
        /// <param name="submitterId"> The submitter identifier. </param>
        /// <param name="artifactId"> The artifact identifier. </param>
        /// <param name="jobType"> The job type. </param>
        /// <param name="result"> The Spark batch job result. </param>
        /// <param name="scheduler"> The scheduler information. </param>
        /// <param name="plugin"> The plugin information. </param>
        /// <param name="errors"> The error information. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="id"> The session Id. </param>
        /// <param name="appId"> The application id of this session. </param>
        /// <param name="appInfo"> The detailed application info. </param>
        /// <param name="state"> The batch state. </param>
        /// <param name="logLines"> The log lines. </param>
        /// <returns> A new <see cref="Models.SparkBatchJob"/> instance for mocking. </returns>
        public static SparkBatchJob SparkBatchJob(SparkBatchJobState livyInfo = null, string name = null, string workspaceName = null, string sparkPoolName = null, string submitterName = null, string submitterId = null, string artifactId = null, SparkJobType? jobType = null, SparkBatchJobResultType? result = null, SparkScheduler scheduler = null, SparkServicePlugin plugin = null, IEnumerable<SparkServiceError> errors = null, IReadOnlyDictionary<string, string> tags = null, int id = default, string appId = null, IReadOnlyDictionary<string, string> appInfo = null, LivyStates? state = null, IEnumerable<string> logLines = null)
        {
            errors ??= new List<SparkServiceError>();
            tags ??= new Dictionary<string, string>();
            appInfo ??= new Dictionary<string, string>();
            logLines ??= new List<string>();

            return new SparkBatchJob(
                livyInfo,
                name,
                workspaceName,
                sparkPoolName,
                submitterName,
                submitterId,
                artifactId,
                jobType,
                result,
                scheduler,
                plugin,
                errors?.ToList(),
                tags,
                id,
                appId,
                appInfo,
                state,
                logLines?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkBatchJobState"/>. </summary>
        /// <param name="notStartedAt"> the time that at which "not_started" livy state was first seen. </param>
        /// <param name="startingAt"> the time that at which "starting" livy state was first seen. </param>
        /// <param name="runningAt"> the time that at which "running" livy state was first seen. </param>
        /// <param name="deadAt"> time that at which "dead" livy state was first seen. </param>
        /// <param name="successAt"> the time that at which "success" livy state was first seen. </param>
        /// <param name="terminatedAt"> the time that at which "killed" livy state was first seen. </param>
        /// <param name="recoveringAt"> the time that at which "recovering" livy state was first seen. </param>
        /// <param name="currentState"> the Spark job state. </param>
        /// <param name="jobCreationRequest"></param>
        /// <returns> A new <see cref="Models.SparkBatchJobState"/> instance for mocking. </returns>
        public static SparkBatchJobState SparkBatchJobState(DateTimeOffset? notStartedAt = null, DateTimeOffset? startingAt = null, DateTimeOffset? runningAt = null, DateTimeOffset? deadAt = null, DateTimeOffset? successAt = null, DateTimeOffset? terminatedAt = null, DateTimeOffset? recoveringAt = null, string currentState = null, SparkRequest jobCreationRequest = null)
        {
            return new SparkBatchJobState(
                notStartedAt,
                startingAt,
                runningAt,
                deadAt,
                successAt,
                terminatedAt,
                recoveringAt,
                currentState,
                jobCreationRequest);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkRequest"/>. </summary>
        /// <param name="name"></param>
        /// <param name="file"></param>
        /// <param name="className"></param>
        /// <param name="arguments"></param>
        /// <param name="jars"></param>
        /// <param name="pythonFiles"></param>
        /// <param name="files"></param>
        /// <param name="archives"></param>
        /// <param name="configuration"> Dictionary of &lt;string&gt;. </param>
        /// <param name="driverMemory"></param>
        /// <param name="driverCores"></param>
        /// <param name="executorMemory"></param>
        /// <param name="executorCores"></param>
        /// <param name="executorCount"></param>
        /// <returns> A new <see cref="Models.SparkRequest"/> instance for mocking. </returns>
        public static SparkRequest SparkRequest(string name = null, string file = null, string className = null, IEnumerable<string> arguments = null, IEnumerable<string> jars = null, IEnumerable<string> pythonFiles = null, IEnumerable<string> files = null, IEnumerable<string> archives = null, IReadOnlyDictionary<string, string> configuration = null, string driverMemory = null, int? driverCores = null, string executorMemory = null, int? executorCores = null, int? executorCount = null)
        {
            arguments ??= new List<string>();
            jars ??= new List<string>();
            pythonFiles ??= new List<string>();
            files ??= new List<string>();
            archives ??= new List<string>();
            configuration ??= new Dictionary<string, string>();

            return new SparkRequest(
                name,
                file,
                className,
                arguments?.ToList(),
                jars?.ToList(),
                pythonFiles?.ToList(),
                files?.ToList(),
                archives?.ToList(),
                configuration,
                driverMemory,
                driverCores,
                executorMemory,
                executorCores,
                executorCount);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkScheduler"/>. </summary>
        /// <param name="submittedAt"></param>
        /// <param name="scheduledAt"></param>
        /// <param name="endedAt"></param>
        /// <param name="cancellationRequestedAt"></param>
        /// <param name="currentState"></param>
        /// <returns> A new <see cref="Models.SparkScheduler"/> instance for mocking. </returns>
        public static SparkScheduler SparkScheduler(DateTimeOffset? submittedAt = null, DateTimeOffset? scheduledAt = null, DateTimeOffset? endedAt = null, DateTimeOffset? cancellationRequestedAt = null, SchedulerCurrentState? currentState = null)
        {
            return new SparkScheduler(submittedAt, scheduledAt, endedAt, cancellationRequestedAt, currentState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkServicePlugin"/>. </summary>
        /// <param name="preparationStartedAt"></param>
        /// <param name="resourceAcquisitionStartedAt"></param>
        /// <param name="submissionStartedAt"></param>
        /// <param name="monitoringStartedAt"></param>
        /// <param name="cleanupStartedAt"></param>
        /// <param name="currentState"></param>
        /// <returns> A new <see cref="Models.SparkServicePlugin"/> instance for mocking. </returns>
        public static SparkServicePlugin SparkServicePlugin(DateTimeOffset? preparationStartedAt = null, DateTimeOffset? resourceAcquisitionStartedAt = null, DateTimeOffset? submissionStartedAt = null, DateTimeOffset? monitoringStartedAt = null, DateTimeOffset? cleanupStartedAt = null, PluginCurrentState? currentState = null)
        {
            return new SparkServicePlugin(
                preparationStartedAt,
                resourceAcquisitionStartedAt,
                submissionStartedAt,
                monitoringStartedAt,
                cleanupStartedAt,
                currentState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkServiceError"/>. </summary>
        /// <param name="message"></param>
        /// <param name="errorCode"></param>
        /// <param name="source"></param>
        /// <returns> A new <see cref="Models.SparkServiceError"/> instance for mocking. </returns>
        public static SparkServiceError SparkServiceError(string message = null, string errorCode = null, SparkErrorSource? source = null)
        {
            return new SparkServiceError(message, errorCode, source);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkSessionCollection"/>. </summary>
        /// <param name="from"></param>
        /// <param name="total"></param>
        /// <param name="sessions"></param>
        /// <returns> A new <see cref="Models.SparkSessionCollection"/> instance for mocking. </returns>
        public static SparkSessionCollection SparkSessionCollection(int @from = default, int total = default, IEnumerable<SparkSession> sessions = null)
        {
            sessions ??= new List<SparkSession>();

            return new SparkSessionCollection(@from, total, sessions?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkSession"/>. </summary>
        /// <param name="livyInfo"></param>
        /// <param name="name"></param>
        /// <param name="workspaceName"></param>
        /// <param name="sparkPoolName"></param>
        /// <param name="submitterName"></param>
        /// <param name="submitterId"></param>
        /// <param name="artifactId"></param>
        /// <param name="jobType"> The job type. </param>
        /// <param name="result"></param>
        /// <param name="scheduler"></param>
        /// <param name="plugin"></param>
        /// <param name="errors"></param>
        /// <param name="tags"> Dictionary of &lt;string&gt;. </param>
        /// <param name="id"></param>
        /// <param name="appId"></param>
        /// <param name="appInfo"> Dictionary of &lt;string&gt;. </param>
        /// <param name="state"> The session state. </param>
        /// <param name="logLines"></param>
        /// <returns> A new <see cref="Models.SparkSession"/> instance for mocking. </returns>
        public static SparkSession SparkSession(SparkSessionState livyInfo = null, string name = null, string workspaceName = null, string sparkPoolName = null, string submitterName = null, string submitterId = null, string artifactId = null, SparkJobType? jobType = null, SparkSessionResultType? result = null, SparkScheduler scheduler = null, SparkServicePlugin plugin = null, IEnumerable<SparkServiceError> errors = null, IReadOnlyDictionary<string, string> tags = null, int id = default, string appId = null, IReadOnlyDictionary<string, string> appInfo = null, LivyStates? state = null, IEnumerable<string> logLines = null)
        {
            errors ??= new List<SparkServiceError>();
            tags ??= new Dictionary<string, string>();
            appInfo ??= new Dictionary<string, string>();
            logLines ??= new List<string>();

            return new SparkSession(
                livyInfo,
                name,
                workspaceName,
                sparkPoolName,
                submitterName,
                submitterId,
                artifactId,
                jobType,
                result,
                scheduler,
                plugin,
                errors?.ToList(),
                tags,
                id,
                appId,
                appInfo,
                state,
                logLines?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkSessionState"/>. </summary>
        /// <param name="notStartedAt"></param>
        /// <param name="startingAt"></param>
        /// <param name="idleAt"></param>
        /// <param name="deadAt"></param>
        /// <param name="shuttingDownAt"></param>
        /// <param name="terminatedAt"></param>
        /// <param name="recoveringAt"></param>
        /// <param name="busyAt"></param>
        /// <param name="errorAt"></param>
        /// <param name="currentState"></param>
        /// <param name="jobCreationRequest"></param>
        /// <returns> A new <see cref="Models.SparkSessionState"/> instance for mocking. </returns>
        public static SparkSessionState SparkSessionState(DateTimeOffset? notStartedAt = null, DateTimeOffset? startingAt = null, DateTimeOffset? idleAt = null, DateTimeOffset? deadAt = null, DateTimeOffset? shuttingDownAt = null, DateTimeOffset? terminatedAt = null, DateTimeOffset? recoveringAt = null, DateTimeOffset? busyAt = null, DateTimeOffset? errorAt = null, string currentState = null, SparkRequest jobCreationRequest = null)
        {
            return new SparkSessionState(
                notStartedAt,
                startingAt,
                idleAt,
                deadAt,
                shuttingDownAt,
                terminatedAt,
                recoveringAt,
                busyAt,
                errorAt,
                currentState,
                jobCreationRequest);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkStatementCollection"/>. </summary>
        /// <param name="total"></param>
        /// <param name="statements"></param>
        /// <returns> A new <see cref="Models.SparkStatementCollection"/> instance for mocking. </returns>
        public static SparkStatementCollection SparkStatementCollection(int total = default, IEnumerable<SparkStatement> statements = null)
        {
            statements ??= new List<SparkStatement>();

            return new SparkStatementCollection(total, statements?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkStatement"/>. </summary>
        /// <param name="id"></param>
        /// <param name="code"></param>
        /// <param name="state"></param>
        /// <param name="output"></param>
        /// <returns> A new <see cref="Models.SparkStatement"/> instance for mocking. </returns>
        public static SparkStatement SparkStatement(int id = default, string code = null, LivyStatementStates? state = null, SparkStatementOutput output = null)
        {
            return new SparkStatement(id, code, state, output);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkStatementOutput"/>. </summary>
        /// <param name="status"></param>
        /// <param name="executionCount"></param>
        /// <param name="data"> Any object. </param>
        /// <param name="errorName"></param>
        /// <param name="errorValue"></param>
        /// <param name="traceback"></param>
        /// <returns> A new <see cref="Models.SparkStatementOutput"/> instance for mocking. </returns>
        public static SparkStatementOutput SparkStatementOutput(string status = null, int executionCount = default, object data = null, string errorName = null, string errorValue = null, IEnumerable<string> traceback = null)
        {
            traceback ??= new List<string>();

            return new SparkStatementOutput(
                status,
                executionCount,
                data,
                errorName,
                errorValue,
                traceback?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkStatementCancellationResult"/>. </summary>
        /// <param name="message"> The msg property from the Livy API. The value is always "canceled". </param>
        /// <returns> A new <see cref="Models.SparkStatementCancellationResult"/> instance for mocking. </returns>
        public static SparkStatementCancellationResult SparkStatementCancellationResult(string message = null)
        {
            return new SparkStatementCancellationResult(message);
        }
    }
}
