// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Analytics.Synapse.Monitoring.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Synapse.Monitoring
{
    /// <summary> The Monitoring service client. </summary>
    public partial class MonitoringClient
    {
        private readonly ClientDiagnostics _clientDiagnostics;
        private readonly HttpPipeline _pipeline;
        internal MonitoringRestClient RestClient { get; }

        /// <summary> Initializes a new instance of MonitoringClient for mocking. </summary>
        protected MonitoringClient()
        {
        }

        /// <summary> Initializes a new instance of MonitoringClient. </summary>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        public MonitoringClient(Uri endpoint, TokenCredential credential, MonitoringClientOptions options = null)
        {
            if (endpoint == null)
            {
                throw new ArgumentNullException(nameof(endpoint));
            }
            if (credential == null)
            {
                throw new ArgumentNullException(nameof(credential));
            }

            options ??= new MonitoringClientOptions();
            _clientDiagnostics = new ClientDiagnostics(options);
            string[] scopes = { "https://dev.azuresynapse.net/.default" };
            _pipeline = HttpPipelineBuilder.Build(options, new BearerTokenAuthenticationPolicy(credential, scopes));
            RestClient = new MonitoringRestClient(_clientDiagnostics, _pipeline, endpoint, options.Version);
        }

        /// <summary> Initializes a new instance of MonitoringClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        internal MonitoringClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint, string apiVersion = "2019-11-01-preview")
        {
            RestClient = new MonitoringRestClient(clientDiagnostics, pipeline, endpoint, apiVersion);
            _clientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
        }

        /// <summary> Get list of spark applications for the workspace. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SparkJobListViewResponse>> GetSparkJobListAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("MonitoringClient.GetSparkJobList");
            scope.Start();
            try
            {
                return await RestClient.GetSparkJobListAsync(cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get list of spark applications for the workspace. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SparkJobListViewResponse> GetSparkJobList(CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("MonitoringClient.GetSparkJobList");
            scope.Start();
            try
            {
                return RestClient.GetSparkJobList(cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get SQL OD/DW Query for the workspace. </summary>
        /// <param name="filter"> The <see cref="string"/> to use. </param>
        /// <param name="orderby"> The <see cref="string"/> to use. </param>
        /// <param name="skip"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlQueryStringDataModel>> GetSqlJobQueryStringAsync(string filter = null, string orderby = null, string skip = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("MonitoringClient.GetSqlJobQueryString");
            scope.Start();
            try
            {
                return await RestClient.GetSqlJobQueryStringAsync(filter, orderby, skip, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get SQL OD/DW Query for the workspace. </summary>
        /// <param name="filter"> The <see cref="string"/> to use. </param>
        /// <param name="orderby"> The <see cref="string"/> to use. </param>
        /// <param name="skip"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlQueryStringDataModel> GetSqlJobQueryString(string filter = null, string orderby = null, string skip = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("MonitoringClient.GetSqlJobQueryString");
            scope.Start();
            try
            {
                return RestClient.GetSqlJobQueryString(filter, orderby, skip, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
