// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Monitoring.Models
{
    /// <summary> The SparkJob. </summary>
    public partial class SparkJob
    {
        /// <summary> Initializes a new instance of <see cref="SparkJob"/>. </summary>
        internal SparkJob()
        {
            Timing = new ChangeTrackingList<string>();
            Pipeline = new ChangeTrackingList<SparkJob>();
        }

        /// <summary> Initializes a new instance of <see cref="SparkJob"/>. </summary>
        /// <param name="state"></param>
        /// <param name="name"></param>
        /// <param name="submitter"></param>
        /// <param name="compute"></param>
        /// <param name="sparkApplicationId"></param>
        /// <param name="livyId"></param>
        /// <param name="timing"></param>
        /// <param name="sparkJobDefinition"></param>
        /// <param name="pipeline"></param>
        /// <param name="jobType"></param>
        /// <param name="submitTime"></param>
        /// <param name="endTime"></param>
        /// <param name="queuedDuration"></param>
        /// <param name="runningDuration"></param>
        /// <param name="totalDuration"></param>
        internal SparkJob(string state, string name, string submitter, string compute, string sparkApplicationId, string livyId, IReadOnlyList<string> timing, string sparkJobDefinition, IReadOnlyList<SparkJob> pipeline, string jobType, DateTimeOffset? submitTime, DateTimeOffset? endTime, string queuedDuration, string runningDuration, string totalDuration)
        {
            State = state;
            Name = name;
            Submitter = submitter;
            Compute = compute;
            SparkApplicationId = sparkApplicationId;
            LivyId = livyId;
            Timing = timing;
            SparkJobDefinition = sparkJobDefinition;
            Pipeline = pipeline;
            JobType = jobType;
            SubmitTime = submitTime;
            EndTime = endTime;
            QueuedDuration = queuedDuration;
            RunningDuration = runningDuration;
            TotalDuration = totalDuration;
        }

        /// <summary> Gets the state. </summary>
        public string State { get; }
        /// <summary> Gets the name. </summary>
        public string Name { get; }
        /// <summary> Gets the submitter. </summary>
        public string Submitter { get; }
        /// <summary> Gets the compute. </summary>
        public string Compute { get; }
        /// <summary> Gets the spark application id. </summary>
        public string SparkApplicationId { get; }
        /// <summary> Gets the livy id. </summary>
        public string LivyId { get; }
        /// <summary> Gets the timing. </summary>
        public IReadOnlyList<string> Timing { get; }
        /// <summary> Gets the spark job definition. </summary>
        public string SparkJobDefinition { get; }
        /// <summary> Gets the pipeline. </summary>
        public IReadOnlyList<SparkJob> Pipeline { get; }
        /// <summary> Gets the job type. </summary>
        public string JobType { get; }
        /// <summary> Gets the submit time. </summary>
        public DateTimeOffset? SubmitTime { get; }
        /// <summary> Gets the end time. </summary>
        public DateTimeOffset? EndTime { get; }
        /// <summary> Gets the queued duration. </summary>
        public string QueuedDuration { get; }
        /// <summary> Gets the running duration. </summary>
        public string RunningDuration { get; }
        /// <summary> Gets the total duration. </summary>
        public string TotalDuration { get; }
    }
}
