// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Analytics.Synapse.Monitoring.Models
{
    public partial class SparkJob
    {
        internal static SparkJob DeserializeSparkJob(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string state = default;
            string name = default;
            string submitter = default;
            string compute = default;
            string sparkApplicationId = default;
            string livyId = default;
            IReadOnlyList<string> timing = default;
            string sparkJobDefinition = default;
            IReadOnlyList<SparkJob> pipeline = default;
            string jobType = default;
            DateTimeOffset? submitTime = default;
            DateTimeOffset? endTime = default;
            string queuedDuration = default;
            string runningDuration = default;
            string totalDuration = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("state"u8))
                {
                    state = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("submitter"u8))
                {
                    submitter = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("compute"u8))
                {
                    compute = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sparkApplicationId"u8))
                {
                    sparkApplicationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("livyId"u8))
                {
                    livyId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timing"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    timing = array;
                    continue;
                }
                if (property.NameEquals("sparkJobDefinition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        sparkJobDefinition = null;
                        continue;
                    }
                    sparkJobDefinition = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("pipeline"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SparkJob> array = new List<SparkJob>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeserializeSparkJob(item));
                    }
                    pipeline = array;
                    continue;
                }
                if (property.NameEquals("jobType"u8))
                {
                    jobType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("submitTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        submitTime = null;
                        continue;
                    }
                    submitTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        endTime = null;
                        continue;
                    }
                    endTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("queuedDuration"u8))
                {
                    queuedDuration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("runningDuration"u8))
                {
                    runningDuration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("totalDuration"u8))
                {
                    totalDuration = property.Value.GetString();
                    continue;
                }
            }
            return new SparkJob(
                state,
                name,
                submitter,
                compute,
                sparkApplicationId,
                livyId,
                timing ?? new ChangeTrackingList<string>(),
                sparkJobDefinition,
                pipeline ?? new ChangeTrackingList<SparkJob>(),
                jobType,
                submitTime,
                endTime,
                queuedDuration,
                runningDuration,
                totalDuration);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SparkJob FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSparkJob(document.RootElement);
        }
    }
}
