// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.ManagedPrivateEndpoints.Models
{
    /// <summary> Properties of a managed private endpoint. </summary>
    public partial class ManagedPrivateEndpointProperties
    {
        /// <summary> Initializes a new instance of <see cref="ManagedPrivateEndpointProperties"/>. </summary>
        public ManagedPrivateEndpointProperties()
        {
            Fqdns = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedPrivateEndpointProperties"/>. </summary>
        /// <param name="name"> The name of managed private endpoint. </param>
        /// <param name="privateLinkResourceId"> The ARM resource ID of the resource to which the managed private endpoint is created. </param>
        /// <param name="groupId"> The groupId to which the managed private endpoint is created. </param>
        /// <param name="provisioningState"> The managed private endpoint provisioning state. </param>
        /// <param name="connectionState"> The managed private endpoint connection state. </param>
        /// <param name="isReserved"> Denotes whether the managed private endpoint is reserved. </param>
        /// <param name="fqdns"> List of fully qualified domain names. </param>
        /// <param name="isCompliant"> Denotes whether the managed private endpoint is compliant. </param>
        internal ManagedPrivateEndpointProperties(string name, string privateLinkResourceId, string groupId, string provisioningState, ManagedPrivateEndpointConnectionState connectionState, bool? isReserved, IList<string> fqdns, bool? isCompliant)
        {
            Name = name;
            PrivateLinkResourceId = privateLinkResourceId;
            GroupId = groupId;
            ProvisioningState = provisioningState;
            ConnectionState = connectionState;
            IsReserved = isReserved;
            Fqdns = fqdns;
            IsCompliant = isCompliant;
        }

        /// <summary> The name of managed private endpoint. </summary>
        public string Name { get; set; }
        /// <summary> The ARM resource ID of the resource to which the managed private endpoint is created. </summary>
        public string PrivateLinkResourceId { get; set; }
        /// <summary> The groupId to which the managed private endpoint is created. </summary>
        public string GroupId { get; set; }
        /// <summary> The managed private endpoint provisioning state. </summary>
        public string ProvisioningState { get; }
        /// <summary> The managed private endpoint connection state. </summary>
        public ManagedPrivateEndpointConnectionState ConnectionState { get; set; }
        /// <summary> Denotes whether the managed private endpoint is reserved. </summary>
        public bool? IsReserved { get; }
        /// <summary> List of fully qualified domain names. </summary>
        public IList<string> Fqdns { get; }
        /// <summary> Denotes whether the managed private endpoint is compliant. </summary>
        public bool? IsCompliant { get; set; }
    }
}
