// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Analytics.Synapse.ManagedPrivateEndpoints.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Synapse.ManagedPrivateEndpoints
{
    /// <summary> The ManagedPrivateEndpoints service client. </summary>
    public partial class ManagedPrivateEndpointsClient
    {
        private readonly ClientDiagnostics _clientDiagnostics;
        private readonly HttpPipeline _pipeline;
        internal ManagedPrivateEndpointsRestClient RestClient { get; }

        /// <summary> Initializes a new instance of ManagedPrivateEndpointsClient for mocking. </summary>
        protected ManagedPrivateEndpointsClient()
        {
        }

        /// <summary> Initializes a new instance of ManagedPrivateEndpointsClient. </summary>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        public ManagedPrivateEndpointsClient(Uri endpoint, TokenCredential credential, ManagedPrivateEndpointsClientOptions options = null)
        {
            if (endpoint == null)
            {
                throw new ArgumentNullException(nameof(endpoint));
            }
            if (credential == null)
            {
                throw new ArgumentNullException(nameof(credential));
            }

            options ??= new ManagedPrivateEndpointsClientOptions();
            _clientDiagnostics = new ClientDiagnostics(options);
            string[] scopes = { "https://dev.azuresynapse.net/.default" };
            _pipeline = HttpPipelineBuilder.Build(options, new BearerTokenAuthenticationPolicy(credential, scopes));
            RestClient = new ManagedPrivateEndpointsRestClient(_clientDiagnostics, _pipeline, endpoint, options.Version);
        }

        /// <summary> Initializes a new instance of ManagedPrivateEndpointsClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        internal ManagedPrivateEndpointsClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint, string apiVersion = "2020-12-01")
        {
            RestClient = new ManagedPrivateEndpointsRestClient(clientDiagnostics, pipeline, endpoint, apiVersion);
            _clientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
        }

        /// <summary> Get Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="managedPrivateEndpointName"> Managed private endpoint name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ManagedPrivateEndpoint>> GetAsync(string managedVirtualNetworkName, string managedPrivateEndpointName, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("ManagedPrivateEndpointsClient.Get");
            scope.Start();
            try
            {
                return await RestClient.GetAsync(managedVirtualNetworkName, managedPrivateEndpointName, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="managedPrivateEndpointName"> Managed private endpoint name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ManagedPrivateEndpoint> Get(string managedVirtualNetworkName, string managedPrivateEndpointName, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("ManagedPrivateEndpointsClient.Get");
            scope.Start();
            try
            {
                return RestClient.Get(managedVirtualNetworkName, managedPrivateEndpointName, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Create Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="managedPrivateEndpointName"> Managed private endpoint name. </param>
        /// <param name="managedPrivateEndpoint"> Managed private endpoint properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ManagedPrivateEndpoint>> CreateAsync(string managedVirtualNetworkName, string managedPrivateEndpointName, ManagedPrivateEndpoint managedPrivateEndpoint, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("ManagedPrivateEndpointsClient.Create");
            scope.Start();
            try
            {
                return await RestClient.CreateAsync(managedVirtualNetworkName, managedPrivateEndpointName, managedPrivateEndpoint, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Create Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="managedPrivateEndpointName"> Managed private endpoint name. </param>
        /// <param name="managedPrivateEndpoint"> Managed private endpoint properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ManagedPrivateEndpoint> Create(string managedVirtualNetworkName, string managedPrivateEndpointName, ManagedPrivateEndpoint managedPrivateEndpoint, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("ManagedPrivateEndpointsClient.Create");
            scope.Start();
            try
            {
                return RestClient.Create(managedVirtualNetworkName, managedPrivateEndpointName, managedPrivateEndpoint, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Delete Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="managedPrivateEndpointName"> Managed private endpoint name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> DeleteAsync(string managedVirtualNetworkName, string managedPrivateEndpointName, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("ManagedPrivateEndpointsClient.Delete");
            scope.Start();
            try
            {
                return await RestClient.DeleteAsync(managedVirtualNetworkName, managedPrivateEndpointName, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Delete Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="managedPrivateEndpointName"> Managed private endpoint name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response Delete(string managedVirtualNetworkName, string managedPrivateEndpointName, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("ManagedPrivateEndpointsClient.Delete");
            scope.Start();
            try
            {
                return RestClient.Delete(managedVirtualNetworkName, managedPrivateEndpointName, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> List Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managedVirtualNetworkName"/> is null. </exception>
        public virtual AsyncPageable<ManagedPrivateEndpoint> ListAsync(string managedVirtualNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedVirtualNetworkName, nameof(managedVirtualNetworkName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => RestClient.CreateListRequest(managedVirtualNetworkName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => RestClient.CreateListNextPageRequest(nextLink, managedVirtualNetworkName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, ManagedPrivateEndpoint.DeserializeManagedPrivateEndpoint, _clientDiagnostics, _pipeline, "ManagedPrivateEndpointsClient.List", "value", "nextLink", cancellationToken);
        }

        /// <summary> List Managed Private Endpoints. </summary>
        /// <param name="managedVirtualNetworkName"> Managed virtual network name. The default value is "default". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managedVirtualNetworkName"/> is null. </exception>
        public virtual Pageable<ManagedPrivateEndpoint> List(string managedVirtualNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedVirtualNetworkName, nameof(managedVirtualNetworkName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => RestClient.CreateListRequest(managedVirtualNetworkName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => RestClient.CreateListNextPageRequest(nextLink, managedVirtualNetworkName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, ManagedPrivateEndpoint.DeserializeManagedPrivateEndpoint, _clientDiagnostics, _pipeline, "ManagedPrivateEndpointsClient.List", "value", "nextLink", cancellationToken);
        }
    }
}
