// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.ManagedPrivateEndpoints.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class AnalyticsSynapseManagedPrivateEndpointsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ManagedPrivateEndpoint"/>. </summary>
        /// <param name="id"> Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts. </param>
        /// <param name="properties"> Managed private endpoint properties. </param>
        /// <returns> A new <see cref="Models.ManagedPrivateEndpoint"/> instance for mocking. </returns>
        public static ManagedPrivateEndpoint ManagedPrivateEndpoint(string id = null, string name = null, string type = null, ManagedPrivateEndpointProperties properties = null)
        {
            return new ManagedPrivateEndpoint(id, name, type, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedPrivateEndpointProperties"/>. </summary>
        /// <param name="name"> The name of managed private endpoint. </param>
        /// <param name="privateLinkResourceId"> The ARM resource ID of the resource to which the managed private endpoint is created. </param>
        /// <param name="groupId"> The groupId to which the managed private endpoint is created. </param>
        /// <param name="provisioningState"> The managed private endpoint provisioning state. </param>
        /// <param name="connectionState"> The managed private endpoint connection state. </param>
        /// <param name="isReserved"> Denotes whether the managed private endpoint is reserved. </param>
        /// <param name="fqdns"> List of fully qualified domain names. </param>
        /// <param name="isCompliant"> Denotes whether the managed private endpoint is compliant. </param>
        /// <returns> A new <see cref="Models.ManagedPrivateEndpointProperties"/> instance for mocking. </returns>
        public static ManagedPrivateEndpointProperties ManagedPrivateEndpointProperties(string name = null, string privateLinkResourceId = null, string groupId = null, string provisioningState = null, ManagedPrivateEndpointConnectionState connectionState = null, bool? isReserved = null, IEnumerable<string> fqdns = null, bool? isCompliant = null)
        {
            fqdns ??= new List<string>();

            return new ManagedPrivateEndpointProperties(
                name,
                privateLinkResourceId,
                groupId,
                provisioningState,
                connectionState,
                isReserved,
                fqdns?.ToList(),
                isCompliant);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedPrivateEndpointConnectionState"/>. </summary>
        /// <param name="status"> The approval status. </param>
        /// <param name="description"> The managed private endpoint description. </param>
        /// <param name="actionsRequired"> The actions required on the managed private endpoint. </param>
        /// <returns> A new <see cref="Models.ManagedPrivateEndpointConnectionState"/> instance for mocking. </returns>
        public static ManagedPrivateEndpointConnectionState ManagedPrivateEndpointConnectionState(string status = null, string description = null, string actionsRequired = null)
        {
            return new ManagedPrivateEndpointConnectionState(status, description, actionsRequired);
        }
    }
}
