// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Parameters for updating a workspace resource. </summary>
    public partial class WorkspaceUpdateParameters
    {
        /// <summary> Initializes a new instance of <see cref="WorkspaceUpdateParameters"/>. </summary>
        public WorkspaceUpdateParameters()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="WorkspaceUpdateParameters"/>. </summary>
        /// <param name="tags"> The resource tags. </param>
        /// <param name="identity"> Managed service identity of the workspace. </param>
        internal WorkspaceUpdateParameters(IDictionary<string, string> tags, WorkspaceIdentity identity)
        {
            Tags = tags;
            Identity = identity;
        }

        /// <summary> The resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> Managed service identity of the workspace. </summary>
        public WorkspaceIdentity Identity { get; set; }
    }
}
