// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Git integration settings. </summary>
    public partial class WorkspaceRepositoryConfiguration
    {
        /// <summary> Initializes a new instance of <see cref="WorkspaceRepositoryConfiguration"/>. </summary>
        public WorkspaceRepositoryConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WorkspaceRepositoryConfiguration"/>. </summary>
        /// <param name="type"> Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration. </param>
        /// <param name="hostName"> GitHub Enterprise host name. For example: https://github.mydomain.com. </param>
        /// <param name="accountName"> Account name. </param>
        /// <param name="projectName"> VSTS project name. </param>
        /// <param name="repositoryName"> Repository name. </param>
        /// <param name="collaborationBranch"> Collaboration branch. </param>
        /// <param name="rootFolder"> Root folder to use in the repository. </param>
        /// <param name="lastCommitId"> The last commit ID. </param>
        /// <param name="tenantId"> The VSTS tenant ID. </param>
        /// <param name="clientId"> GitHub bring your own app client id. </param>
        /// <param name="clientSecret"> GitHub bring your own app client secret information. </param>
        internal WorkspaceRepositoryConfiguration(string type, string hostName, string accountName, string projectName, string repositoryName, string collaborationBranch, string rootFolder, string lastCommitId, Guid? tenantId, string clientId, GitHubClientSecret clientSecret)
        {
            Type = type;
            HostName = hostName;
            AccountName = accountName;
            ProjectName = projectName;
            RepositoryName = repositoryName;
            CollaborationBranch = collaborationBranch;
            RootFolder = rootFolder;
            LastCommitId = lastCommitId;
            TenantId = tenantId;
            ClientId = clientId;
            ClientSecret = clientSecret;
        }

        /// <summary> Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration. </summary>
        public string Type { get; set; }
        /// <summary> GitHub Enterprise host name. For example: https://github.mydomain.com. </summary>
        public string HostName { get; set; }
        /// <summary> Account name. </summary>
        public string AccountName { get; set; }
        /// <summary> VSTS project name. </summary>
        public string ProjectName { get; set; }
        /// <summary> Repository name. </summary>
        public string RepositoryName { get; set; }
        /// <summary> Collaboration branch. </summary>
        public string CollaborationBranch { get; set; }
        /// <summary> Root folder to use in the repository. </summary>
        public string RootFolder { get; set; }
        /// <summary> The last commit ID. </summary>
        public string LastCommitId { get; set; }
        /// <summary> The VSTS tenant ID. </summary>
        public Guid? TenantId { get; set; }
        /// <summary> GitHub bring your own app client id. </summary>
        public string ClientId { get; set; }
        /// <summary> GitHub bring your own app client secret information. </summary>
        public GitHubClientSecret ClientSecret { get; set; }
    }
}
