// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The identity type. Currently the only supported type is 'SystemAssigned'. </summary>
    public readonly partial struct WorkspaceIdentityType : IEquatable<WorkspaceIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkspaceIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkspaceIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemAssignedValue = "SystemAssigned";

        /// <summary> SystemAssigned. </summary>
        public static WorkspaceIdentityType SystemAssigned { get; } = new WorkspaceIdentityType(SystemAssignedValue);
        /// <summary> Determines if two <see cref="WorkspaceIdentityType"/> values are the same. </summary>
        public static bool operator ==(WorkspaceIdentityType left, WorkspaceIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkspaceIdentityType"/> values are not the same. </summary>
        public static bool operator !=(WorkspaceIdentityType left, WorkspaceIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkspaceIdentityType"/>. </summary>
        public static implicit operator WorkspaceIdentityType(string value) => new WorkspaceIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkspaceIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkspaceIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
