// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Unknown version of StoreWriteSettings. </summary>
    internal partial class UnknownStoreWriteSettings : StoreWriteSettings
    {
        /// <summary> Initializes a new instance of <see cref="UnknownStoreWriteSettings"/>. </summary>
        /// <param name="type"> The write setting type. </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="copyBehavior"> The type of copy behavior for copy sink. </param>
        /// <param name="metadata"> Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal UnknownStoreWriteSettings(string type, object maxConcurrentConnections, object copyBehavior, IList<MetadataItem> metadata, IDictionary<string, object> additionalProperties) : base(type, maxConcurrentConnections, copyBehavior, metadata, additionalProperties)
        {
            Type = type ?? "Unknown";
        }
    }
}
