// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Type conversion settings. </summary>
    public partial class TypeConversionSettings
    {
        /// <summary> Initializes a new instance of <see cref="TypeConversionSettings"/>. </summary>
        public TypeConversionSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TypeConversionSettings"/>. </summary>
        /// <param name="allowDataTruncation"> Whether to allow data truncation when converting the data. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="treatBooleanAsNumber"> Whether to treat boolean values as numbers. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="dateTimeFormat"> The format for DateTime values. Type: string (or Expression with resultType string). </param>
        /// <param name="dateTimeOffsetFormat"> The format for DateTimeOffset values. Type: string (or Expression with resultType string). </param>
        /// <param name="timeSpanFormat"> The format for TimeSpan values. Type: string (or Expression with resultType string). </param>
        /// <param name="culture"> The culture used to convert data from/to string. Type: string (or Expression with resultType string). </param>
        internal TypeConversionSettings(object allowDataTruncation, object treatBooleanAsNumber, object dateTimeFormat, object dateTimeOffsetFormat, object timeSpanFormat, object culture)
        {
            AllowDataTruncation = allowDataTruncation;
            TreatBooleanAsNumber = treatBooleanAsNumber;
            DateTimeFormat = dateTimeFormat;
            DateTimeOffsetFormat = dateTimeOffsetFormat;
            TimeSpanFormat = timeSpanFormat;
            Culture = culture;
        }

        /// <summary> Whether to allow data truncation when converting the data. Type: boolean (or Expression with resultType boolean). </summary>
        public object AllowDataTruncation { get; set; }
        /// <summary> Whether to treat boolean values as numbers. Type: boolean (or Expression with resultType boolean). </summary>
        public object TreatBooleanAsNumber { get; set; }
        /// <summary> The format for DateTime values. Type: string (or Expression with resultType string). </summary>
        public object DateTimeFormat { get; set; }
        /// <summary> The format for DateTimeOffset values. Type: string (or Expression with resultType string). </summary>
        public object DateTimeOffsetFormat { get; set; }
        /// <summary> The format for TimeSpan values. Type: string (or Expression with resultType string). </summary>
        public object TimeSpanFormat { get; set; }
        /// <summary> The culture used to convert data from/to string. Type: string (or Expression with resultType string). </summary>
        public object Culture { get; set; }
    }
}
