// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(TypeConversionSettingsConverter))]
    public partial class TypeConversionSettings : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(AllowDataTruncation))
            {
                writer.WritePropertyName("allowDataTruncation"u8);
                writer.WriteObjectValue<object>(AllowDataTruncation);
            }
            if (Optional.IsDefined(TreatBooleanAsNumber))
            {
                writer.WritePropertyName("treatBooleanAsNumber"u8);
                writer.WriteObjectValue<object>(TreatBooleanAsNumber);
            }
            if (Optional.IsDefined(DateTimeFormat))
            {
                writer.WritePropertyName("dateTimeFormat"u8);
                writer.WriteObjectValue<object>(DateTimeFormat);
            }
            if (Optional.IsDefined(DateTimeOffsetFormat))
            {
                writer.WritePropertyName("dateTimeOffsetFormat"u8);
                writer.WriteObjectValue<object>(DateTimeOffsetFormat);
            }
            if (Optional.IsDefined(TimeSpanFormat))
            {
                writer.WritePropertyName("timeSpanFormat"u8);
                writer.WriteObjectValue<object>(TimeSpanFormat);
            }
            if (Optional.IsDefined(Culture))
            {
                writer.WritePropertyName("culture"u8);
                writer.WriteObjectValue<object>(Culture);
            }
            writer.WriteEndObject();
        }

        internal static TypeConversionSettings DeserializeTypeConversionSettings(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            object allowDataTruncation = default;
            object treatBooleanAsNumber = default;
            object dateTimeFormat = default;
            object dateTimeOffsetFormat = default;
            object timeSpanFormat = default;
            object culture = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("allowDataTruncation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowDataTruncation = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("treatBooleanAsNumber"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    treatBooleanAsNumber = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("dateTimeFormat"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dateTimeFormat = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("dateTimeOffsetFormat"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dateTimeOffsetFormat = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("timeSpanFormat"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeSpanFormat = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("culture"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    culture = property.Value.GetObject();
                    continue;
                }
            }
            return new TypeConversionSettings(
                allowDataTruncation,
                treatBooleanAsNumber,
                dateTimeFormat,
                dateTimeOffsetFormat,
                timeSpanFormat,
                culture);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TypeConversionSettings FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTypeConversionSettings(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class TypeConversionSettingsConverter : JsonConverter<TypeConversionSettings>
        {
            public override void Write(Utf8JsonWriter writer, TypeConversionSettings model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override TypeConversionSettings Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeTypeConversionSettings(document.RootElement);
            }
        }
    }
}
