// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Trigger that schedules pipeline runs for all fixed time interval windows from a start time without gaps and also supports backfill scenarios (when start time is in the past). </summary>
    public partial class TumblingWindowTrigger : Trigger
    {
        /// <summary> Initializes a new instance of <see cref="TumblingWindowTrigger"/>. </summary>
        /// <param name="pipeline"> Pipeline for which runs are created when an event is fired for trigger window that is ready. </param>
        /// <param name="frequency"> The frequency of the time windows. </param>
        /// <param name="interval"> The interval of the time windows. The minimum interval allowed is 15 Minutes. </param>
        /// <param name="startTime"> The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </param>
        /// <param name="maxConcurrency"> The max number of parallel time windows (ready for execution) for which a new run is triggered. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> is null. </exception>
        public TumblingWindowTrigger(TriggerPipelineReference pipeline, TumblingWindowFrequency frequency, int interval, DateTimeOffset startTime, int maxConcurrency)
        {
            Argument.AssertNotNull(pipeline, nameof(pipeline));

            Pipeline = pipeline;
            Frequency = frequency;
            Interval = interval;
            StartTime = startTime;
            MaxConcurrency = maxConcurrency;
            DependsOn = new ChangeTrackingList<DependencyReference>();
            Type = "TumblingWindowTrigger";
        }

        /// <summary> Initializes a new instance of <see cref="TumblingWindowTrigger"/>. </summary>
        /// <param name="type"> Trigger type. </param>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipeline"> Pipeline for which runs are created when an event is fired for trigger window that is ready. </param>
        /// <param name="frequency"> The frequency of the time windows. </param>
        /// <param name="interval"> The interval of the time windows. The minimum interval allowed is 15 Minutes. </param>
        /// <param name="startTime"> The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </param>
        /// <param name="endTime"> The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </param>
        /// <param name="delay"> Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrency"> The max number of parallel time windows (ready for execution) for which a new run is triggered. </param>
        /// <param name="retryPolicy"> Retry policy that will be applied for failed pipeline runs. </param>
        /// <param name="dependsOn">
        /// Triggers that this trigger depends on. Only tumbling window triggers are supported.
        /// Please note <see cref="DependencyReference"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SelfDependencyTumblingWindowTriggerReference"/>, <see cref="TriggerDependencyReference"/> and <see cref="TumblingWindowTriggerDependencyReference"/>.
        /// </param>
        internal TumblingWindowTrigger(string type, string description, TriggerRuntimeState? runtimeState, IList<object> annotations, IDictionary<string, object> additionalProperties, TriggerPipelineReference pipeline, TumblingWindowFrequency frequency, int interval, DateTimeOffset startTime, DateTimeOffset? endTime, object delay, int maxConcurrency, RetryPolicy retryPolicy, IList<DependencyReference> dependsOn) : base(type, description, runtimeState, annotations, additionalProperties)
        {
            Pipeline = pipeline;
            Frequency = frequency;
            Interval = interval;
            StartTime = startTime;
            EndTime = endTime;
            Delay = delay;
            MaxConcurrency = maxConcurrency;
            RetryPolicy = retryPolicy;
            DependsOn = dependsOn;
            Type = type ?? "TumblingWindowTrigger";
        }

        /// <summary> Pipeline for which runs are created when an event is fired for trigger window that is ready. </summary>
        public TriggerPipelineReference Pipeline { get; set; }
        /// <summary> The frequency of the time windows. </summary>
        public TumblingWindowFrequency Frequency { get; set; }
        /// <summary> The interval of the time windows. The minimum interval allowed is 15 Minutes. </summary>
        public int Interval { get; set; }
        /// <summary> The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </summary>
        public DateTimeOffset StartTime { get; set; }
        /// <summary> The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </summary>
        public DateTimeOffset? EndTime { get; set; }
        /// <summary> Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </summary>
        public object Delay { get; set; }
        /// <summary> The max number of parallel time windows (ready for execution) for which a new run is triggered. </summary>
        public int MaxConcurrency { get; set; }
        /// <summary> Retry policy that will be applied for failed pipeline runs. </summary>
        public RetryPolicy RetryPolicy { get; set; }
        /// <summary>
        /// Triggers that this trigger depends on. Only tumbling window triggers are supported.
        /// Please note <see cref="DependencyReference"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SelfDependencyTumblingWindowTriggerReference"/>, <see cref="TriggerDependencyReference"/> and <see cref="TumblingWindowTriggerDependencyReference"/>.
        /// </summary>
        public IList<DependencyReference> DependsOn { get; }
    }
}
