// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Trigger run status. </summary>
    public readonly partial struct TriggerRunStatus : IEquatable<TriggerRunStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TriggerRunStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TriggerRunStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string InProgressValue = "Inprogress";

        /// <summary> Succeeded. </summary>
        public static TriggerRunStatus Succeeded { get; } = new TriggerRunStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static TriggerRunStatus Failed { get; } = new TriggerRunStatus(FailedValue);
        /// <summary> Inprogress. </summary>
        public static TriggerRunStatus InProgress { get; } = new TriggerRunStatus(InProgressValue);
        /// <summary> Determines if two <see cref="TriggerRunStatus"/> values are the same. </summary>
        public static bool operator ==(TriggerRunStatus left, TriggerRunStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TriggerRunStatus"/> values are not the same. </summary>
        public static bool operator !=(TriggerRunStatus left, TriggerRunStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TriggerRunStatus"/>. </summary>
        public static implicit operator TriggerRunStatus(string value) => new TriggerRunStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TriggerRunStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TriggerRunStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
