// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The data stored in text format. </summary>
    public partial class TextFormat : DatasetStorageFormat
    {
        /// <summary> Initializes a new instance of <see cref="TextFormat"/>. </summary>
        public TextFormat()
        {
            Type = "TextFormat";
        }

        /// <summary> Initializes a new instance of <see cref="TextFormat"/>. </summary>
        /// <param name="type"> Type of dataset storage format. </param>
        /// <param name="serializer"> Serializer. Type: string (or Expression with resultType string). </param>
        /// <param name="deserializer"> Deserializer. Type: string (or Expression with resultType string). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="columnDelimiter"> The column delimiter. Type: string (or Expression with resultType string). </param>
        /// <param name="rowDelimiter"> The row delimiter. Type: string (or Expression with resultType string). </param>
        /// <param name="escapeChar"> The escape character. Type: string (or Expression with resultType string). </param>
        /// <param name="quoteChar"> The quote character. Type: string (or Expression with resultType string). </param>
        /// <param name="nullValue"> The null value string. Type: string (or Expression with resultType string). </param>
        /// <param name="encodingName"> The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string). </param>
        /// <param name="treatEmptyAsNull"> Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="skipLineCount"> The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer). </param>
        /// <param name="firstRowAsHeader"> When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean). </param>
        internal TextFormat(string type, object serializer, object deserializer, IDictionary<string, object> additionalProperties, object columnDelimiter, object rowDelimiter, object escapeChar, object quoteChar, object nullValue, object encodingName, object treatEmptyAsNull, object skipLineCount, object firstRowAsHeader) : base(type, serializer, deserializer, additionalProperties)
        {
            ColumnDelimiter = columnDelimiter;
            RowDelimiter = rowDelimiter;
            EscapeChar = escapeChar;
            QuoteChar = quoteChar;
            NullValue = nullValue;
            EncodingName = encodingName;
            TreatEmptyAsNull = treatEmptyAsNull;
            SkipLineCount = skipLineCount;
            FirstRowAsHeader = firstRowAsHeader;
            Type = type ?? "TextFormat";
        }

        /// <summary> The column delimiter. Type: string (or Expression with resultType string). </summary>
        public object ColumnDelimiter { get; set; }
        /// <summary> The row delimiter. Type: string (or Expression with resultType string). </summary>
        public object RowDelimiter { get; set; }
        /// <summary> The escape character. Type: string (or Expression with resultType string). </summary>
        public object EscapeChar { get; set; }
        /// <summary> The quote character. Type: string (or Expression with resultType string). </summary>
        public object QuoteChar { get; set; }
        /// <summary> The null value string. Type: string (or Expression with resultType string). </summary>
        public object NullValue { get; set; }
        /// <summary> The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string). </summary>
        public object EncodingName { get; set; }
        /// <summary> Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean). </summary>
        public object TreatEmptyAsNull { get; set; }
        /// <summary> The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer). </summary>
        public object SkipLineCount { get; set; }
        /// <summary> When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean). </summary>
        public object FirstRowAsHeader { get; set; }
    }
}
