// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The partition mechanism that will be used for teradata read in parallel. </summary>
    public readonly partial struct TeradataPartitionOption : IEquatable<TeradataPartitionOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TeradataPartitionOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TeradataPartitionOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string HashValue = "Hash";
        private const string DynamicRangeValue = "DynamicRange";

        /// <summary> None. </summary>
        public static TeradataPartitionOption None { get; } = new TeradataPartitionOption(NoneValue);
        /// <summary> Hash. </summary>
        public static TeradataPartitionOption Hash { get; } = new TeradataPartitionOption(HashValue);
        /// <summary> DynamicRange. </summary>
        public static TeradataPartitionOption DynamicRange { get; } = new TeradataPartitionOption(DynamicRangeValue);
        /// <summary> Determines if two <see cref="TeradataPartitionOption"/> values are the same. </summary>
        public static bool operator ==(TeradataPartitionOption left, TeradataPartitionOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TeradataPartitionOption"/> values are not the same. </summary>
        public static bool operator !=(TeradataPartitionOption left, TeradataPartitionOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TeradataPartitionOption"/>. </summary>
        public static implicit operator TeradataPartitionOption(string value) => new TeradataPartitionOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TeradataPartitionOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TeradataPartitionOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
