// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Linked service for TeamDesk. </summary>
    public partial class TeamDeskLinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="TeamDeskLinkedService"/>. </summary>
        /// <param name="authenticationType"> The authentication type to use. </param>
        /// <param name="url"> The url to connect TeamDesk source. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="url"/> is null. </exception>
        public TeamDeskLinkedService(TeamDeskAuthenticationType authenticationType, object url)
        {
            Argument.AssertNotNull(url, nameof(url));

            AuthenticationType = authenticationType;
            Url = url;
            Type = "TeamDesk";
        }

        /// <summary> Initializes a new instance of <see cref="TeamDeskLinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="authenticationType"> The authentication type to use. </param>
        /// <param name="url"> The url to connect TeamDesk source. Type: string (or Expression with resultType string). </param>
        /// <param name="userName"> The username of the TeamDesk source. Type: string (or Expression with resultType string). </param>
        /// <param name="password">
        /// The password of the TeamDesk source.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="apiToken">
        /// The api token for the TeamDesk source.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </param>
        internal TeamDeskLinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, TeamDeskAuthenticationType authenticationType, object url, object userName, SecretBase password, SecretBase apiToken, object encryptedCredential) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            AuthenticationType = authenticationType;
            Url = url;
            UserName = userName;
            Password = password;
            ApiToken = apiToken;
            EncryptedCredential = encryptedCredential;
            Type = type ?? "TeamDesk";
        }

        /// <summary> The authentication type to use. </summary>
        public TeamDeskAuthenticationType AuthenticationType { get; set; }
        /// <summary> The url to connect TeamDesk source. Type: string (or Expression with resultType string). </summary>
        public object Url { get; set; }
        /// <summary> The username of the TeamDesk source. Type: string (or Expression with resultType string). </summary>
        public object UserName { get; set; }
        /// <summary>
        /// The password of the TeamDesk source.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase Password { get; set; }
        /// <summary>
        /// The api token for the TeamDesk source.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase ApiToken { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </summary>
        public object EncryptedCredential { get; set; }
    }
}
