// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A copy activity tabular translator. </summary>
    public partial class TabularTranslator : CopyTranslator
    {
        /// <summary> Initializes a new instance of <see cref="TabularTranslator"/>. </summary>
        public TabularTranslator()
        {
            Type = "TabularTranslator";
        }

        /// <summary> Initializes a new instance of <see cref="TabularTranslator"/>. </summary>
        /// <param name="type"> Copy translator type. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="columnMappings"> Column mappings. Example: "UserId: MyUserId, Group: MyGroup, Name: MyName" Type: string (or Expression with resultType string). This property will be retired. Please use mappings property. </param>
        /// <param name="schemaMapping"> The schema mapping to map between tabular data and hierarchical data. Example: {"Column1": "$.Column1", "Column2": "$.Column2.Property1", "Column3": "$.Column2.Property2"}. Type: object (or Expression with resultType object). This property will be retired. Please use mappings property. </param>
        /// <param name="collectionReference"> The JSON Path of the Nested Array that is going to do cross-apply. Type: object (or Expression with resultType object). </param>
        /// <param name="mapComplexValuesToString"> Whether to map complex (array and object) values to simple strings in json format. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="mappings"> Column mappings with logical types. Tabular-&gt;tabular example: [{"source":{"name":"CustomerName","type":"String"},"sink":{"name":"ClientName","type":"String"}},{"source":{"name":"CustomerAddress","type":"String"},"sink":{"name":"ClientAddress","type":"String"}}].  Hierarchical-&gt;tabular example: [{"source":{"path":"$.CustomerName","type":"String"},"sink":{"name":"ClientName","type":"String"}},{"source":{"path":"$.CustomerAddress","type":"String"},"sink":{"name":"ClientAddress","type":"String"}}]. Type: object (or Expression with resultType object). </param>
        /// <param name="typeConversion"> Whether to enable the advanced type conversion feature in the Copy activity. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="typeConversionSettings"> Type conversion settings. </param>
        internal TabularTranslator(string type, IDictionary<string, object> additionalProperties, object columnMappings, object schemaMapping, object collectionReference, object mapComplexValuesToString, object mappings, object typeConversion, TypeConversionSettings typeConversionSettings) : base(type, additionalProperties)
        {
            ColumnMappings = columnMappings;
            SchemaMapping = schemaMapping;
            CollectionReference = collectionReference;
            MapComplexValuesToString = mapComplexValuesToString;
            Mappings = mappings;
            TypeConversion = typeConversion;
            TypeConversionSettings = typeConversionSettings;
            Type = type ?? "TabularTranslator";
        }

        /// <summary> Column mappings. Example: "UserId: MyUserId, Group: MyGroup, Name: MyName" Type: string (or Expression with resultType string). This property will be retired. Please use mappings property. </summary>
        public object ColumnMappings { get; set; }
        /// <summary> The schema mapping to map between tabular data and hierarchical data. Example: {"Column1": "$.Column1", "Column2": "$.Column2.Property1", "Column3": "$.Column2.Property2"}. Type: object (or Expression with resultType object). This property will be retired. Please use mappings property. </summary>
        public object SchemaMapping { get; set; }
        /// <summary> The JSON Path of the Nested Array that is going to do cross-apply. Type: object (or Expression with resultType object). </summary>
        public object CollectionReference { get; set; }
        /// <summary> Whether to map complex (array and object) values to simple strings in json format. Type: boolean (or Expression with resultType boolean). </summary>
        public object MapComplexValuesToString { get; set; }
        /// <summary> Column mappings with logical types. Tabular-&gt;tabular example: [{"source":{"name":"CustomerName","type":"String"},"sink":{"name":"ClientName","type":"String"}},{"source":{"name":"CustomerAddress","type":"String"},"sink":{"name":"ClientAddress","type":"String"}}].  Hierarchical-&gt;tabular example: [{"source":{"path":"$.CustomerName","type":"String"},"sink":{"name":"ClientName","type":"String"}},{"source":{"path":"$.CustomerAddress","type":"String"},"sink":{"name":"ClientAddress","type":"String"}}]. Type: object (or Expression with resultType object). </summary>
        public object Mappings { get; set; }
        /// <summary> Whether to enable the advanced type conversion feature in the Copy activity. Type: boolean (or Expression with resultType boolean). </summary>
        public object TypeConversion { get; set; }
        /// <summary> Type conversion settings. </summary>
        public TypeConversionSettings TypeConversionSettings { get; set; }
    }
}
