// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Synapse spark job reference type. </summary>
    public partial class SynapseSparkJobReference
    {
        /// <summary> Initializes a new instance of <see cref="SynapseSparkJobReference"/>. </summary>
        /// <param name="type"> Synapse spark job reference type. </param>
        /// <param name="referenceName"> Reference spark job name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="referenceName"/> is null. </exception>
        public SynapseSparkJobReference(SparkJobReferenceType type, string referenceName)
        {
            Argument.AssertNotNull(referenceName, nameof(referenceName));

            Type = type;
            ReferenceName = referenceName;
        }

        /// <summary> Synapse spark job reference type. </summary>
        public SparkJobReferenceType Type { get; set; }
        /// <summary> Reference spark job name. </summary>
        public string ReferenceName { get; set; }
    }
}
