// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Execute spark job activity. </summary>
    public partial class SynapseSparkJobDefinitionActivity : ExecutionActivity
    {
        /// <summary> Initializes a new instance of <see cref="SynapseSparkJobDefinitionActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="sparkJob"> Synapse spark job reference. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="sparkJob"/> is null. </exception>
        public SynapseSparkJobDefinitionActivity(string name, SynapseSparkJobReference sparkJob) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(sparkJob, nameof(sparkJob));

            SparkJob = sparkJob;
            Arguments = new ChangeTrackingList<object>();
            Files = new ChangeTrackingList<object>();
            PythonCodeReference = new ChangeTrackingList<object>();
            FilesV2 = new ChangeTrackingList<object>();
            SparkConfig = new ChangeTrackingDictionary<string, object>();
            Type = "SparkJob";
        }

        /// <summary> Initializes a new instance of <see cref="SynapseSparkJobDefinitionActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="type"> Type of activity. </param>
        /// <param name="description"> Activity description. </param>
        /// <param name="state"> Activity state. This is an optional property and if not provided, the state will be Active by default. </param>
        /// <param name="onInactiveMarkAs"> Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default. </param>
        /// <param name="dependsOn"> Activity depends on condition. </param>
        /// <param name="userProperties"> Activity user properties. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="linkedServiceName"> Linked service reference. </param>
        /// <param name="policy"> Activity policy. </param>
        /// <param name="sparkJob"> Synapse spark job reference. </param>
        /// <param name="arguments"> User specified arguments to SynapseSparkJobDefinitionActivity. </param>
        /// <param name="file"> The main file used for the job, which will override the 'file' of the spark job definition you provide. Type: string (or Expression with resultType string). </param>
        /// <param name="scanFolder"> Scanning subfolders from the root folder of the main definition file, these files will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and the folders name are case sensitive. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="className"> The fully-qualified identifier or the main class that is in the main definition file, which will override the 'className' of the spark job definition you provide. Type: string (or Expression with resultType string). </param>
        /// <param name="files"> (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide. </param>
        /// <param name="pythonCodeReference"> Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide. </param>
        /// <param name="filesV2"> Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide. </param>
        /// <param name="targetBigDataPool"> The name of the big data pool which will be used to execute the spark batch job, which will override the 'targetBigDataPool' of the spark job definition you provide. </param>
        /// <param name="executorSize"> Number of core and memory to be used for executors allocated in the specified Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job definition you provide. Type: string (or Expression with resultType string). </param>
        /// <param name="conf"> Spark configuration properties, which will override the 'conf' of the spark job definition you provide. </param>
        /// <param name="driverSize"> Number of core and memory to be used for driver allocated in the specified Spark pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition you provide. Type: string (or Expression with resultType string). </param>
        /// <param name="numExecutors"> Number of executors to launch for this job, which will override the 'numExecutors' of the spark job definition you provide. Type: integer (or Expression with resultType integer). </param>
        /// <param name="configurationType"> The type of the spark config. </param>
        /// <param name="targetSparkConfiguration"> The spark configuration of the spark job. </param>
        /// <param name="sparkConfig"> Spark configuration property. </param>
        internal SynapseSparkJobDefinitionActivity(string name, string type, string description, ActivityState? state, ActivityOnInactiveMarkAs? onInactiveMarkAs, IList<ActivityDependency> dependsOn, IList<UserProperty> userProperties, IDictionary<string, object> additionalProperties, LinkedServiceReference linkedServiceName, ActivityPolicy policy, SynapseSparkJobReference sparkJob, IList<object> arguments, object file, object scanFolder, object className, IList<object> files, IList<object> pythonCodeReference, IList<object> filesV2, BigDataPoolParametrizationReference targetBigDataPool, object executorSize, object conf, object driverSize, object numExecutors, ConfigurationType? configurationType, SparkConfigurationParametrizationReference targetSparkConfiguration, IDictionary<string, object> sparkConfig) : base(name, type, description, state, onInactiveMarkAs, dependsOn, userProperties, additionalProperties, linkedServiceName, policy)
        {
            SparkJob = sparkJob;
            Arguments = arguments;
            File = file;
            ScanFolder = scanFolder;
            ClassName = className;
            Files = files;
            PythonCodeReference = pythonCodeReference;
            FilesV2 = filesV2;
            TargetBigDataPool = targetBigDataPool;
            ExecutorSize = executorSize;
            Conf = conf;
            DriverSize = driverSize;
            NumExecutors = numExecutors;
            ConfigurationType = configurationType;
            TargetSparkConfiguration = targetSparkConfiguration;
            SparkConfig = sparkConfig;
            Type = type ?? "SparkJob";
        }

        /// <summary> Synapse spark job reference. </summary>
        public SynapseSparkJobReference SparkJob { get; set; }
        /// <summary> User specified arguments to SynapseSparkJobDefinitionActivity. </summary>
        public IList<object> Arguments { get; }
        /// <summary> The main file used for the job, which will override the 'file' of the spark job definition you provide. Type: string (or Expression with resultType string). </summary>
        public object File { get; set; }
        /// <summary> Scanning subfolders from the root folder of the main definition file, these files will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and the folders name are case sensitive. Type: boolean (or Expression with resultType boolean). </summary>
        public object ScanFolder { get; set; }
        /// <summary> The fully-qualified identifier or the main class that is in the main definition file, which will override the 'className' of the spark job definition you provide. Type: string (or Expression with resultType string). </summary>
        public object ClassName { get; set; }
        /// <summary> (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide. </summary>
        public IList<object> Files { get; }
        /// <summary> Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide. </summary>
        public IList<object> PythonCodeReference { get; }
        /// <summary> Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide. </summary>
        public IList<object> FilesV2 { get; }
        /// <summary> The name of the big data pool which will be used to execute the spark batch job, which will override the 'targetBigDataPool' of the spark job definition you provide. </summary>
        public BigDataPoolParametrizationReference TargetBigDataPool { get; set; }
        /// <summary> Number of core and memory to be used for executors allocated in the specified Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job definition you provide. Type: string (or Expression with resultType string). </summary>
        public object ExecutorSize { get; set; }
        /// <summary> Spark configuration properties, which will override the 'conf' of the spark job definition you provide. </summary>
        public object Conf { get; set; }
        /// <summary> Number of core and memory to be used for driver allocated in the specified Spark pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition you provide. Type: string (or Expression with resultType string). </summary>
        public object DriverSize { get; set; }
        /// <summary> Number of executors to launch for this job, which will override the 'numExecutors' of the spark job definition you provide. Type: integer (or Expression with resultType integer). </summary>
        public object NumExecutors { get; set; }
        /// <summary> The type of the spark config. </summary>
        public ConfigurationType? ConfigurationType { get; set; }
        /// <summary> The spark configuration of the spark job. </summary>
        public SparkConfigurationParametrizationReference TargetSparkConfiguration { get; set; }
        /// <summary> Spark configuration property. </summary>
        public IDictionary<string, object> SparkConfig { get; }
    }
}
