// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Synapse notebook reference type. </summary>
    public partial class SynapseNotebookReference
    {
        /// <summary> Initializes a new instance of <see cref="SynapseNotebookReference"/>. </summary>
        /// <param name="type"> Synapse notebook reference type. </param>
        /// <param name="referenceName"> Reference notebook name. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="referenceName"/> is null. </exception>
        public SynapseNotebookReference(NotebookReferenceType type, object referenceName)
        {
            Argument.AssertNotNull(referenceName, nameof(referenceName));

            Type = type;
            ReferenceName = referenceName;
        }

        /// <summary> Synapse notebook reference type. </summary>
        public NotebookReferenceType Type { get; set; }
        /// <summary> Reference notebook name. Type: string (or Expression with resultType string). </summary>
        public object ReferenceName { get; set; }
    }
}
