// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The type of SSIS package location. </summary>
    public readonly partial struct SsisPackageLocationType : IEquatable<SsisPackageLocationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SsisPackageLocationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SsisPackageLocationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SsisdbValue = "SSISDB";
        private const string FileValue = "File";
        private const string InlinePackageValue = "InlinePackage";
        private const string PackageStoreValue = "PackageStore";

        /// <summary> SSISDB. </summary>
        public static SsisPackageLocationType Ssisdb { get; } = new SsisPackageLocationType(SsisdbValue);
        /// <summary> File. </summary>
        public static SsisPackageLocationType File { get; } = new SsisPackageLocationType(FileValue);
        /// <summary> InlinePackage. </summary>
        public static SsisPackageLocationType InlinePackage { get; } = new SsisPackageLocationType(InlinePackageValue);
        /// <summary> PackageStore. </summary>
        public static SsisPackageLocationType PackageStore { get; } = new SsisPackageLocationType(PackageStoreValue);
        /// <summary> Determines if two <see cref="SsisPackageLocationType"/> values are the same. </summary>
        public static bool operator ==(SsisPackageLocationType left, SsisPackageLocationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SsisPackageLocationType"/> values are not the same. </summary>
        public static bool operator !=(SsisPackageLocationType left, SsisPackageLocationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SsisPackageLocationType"/>. </summary>
        public static implicit operator SsisPackageLocationType(string value) => new SsisPackageLocationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SsisPackageLocationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SsisPackageLocationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
