// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> SSIS execution parameter. </summary>
    public partial class SsisExecutionParameter
    {
        /// <summary> Initializes a new instance of <see cref="SsisExecutionParameter"/>. </summary>
        /// <param name="value"> SSIS package execution parameter value. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SsisExecutionParameter(object value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value;
        }

        /// <summary> SSIS package execution parameter value. Type: string (or Expression with resultType string). </summary>
        public object Value { get; set; }
    }
}
