// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> SSIS embedded child package. </summary>
    public partial class SsisChildPackage
    {
        /// <summary> Initializes a new instance of <see cref="SsisChildPackage"/>. </summary>
        /// <param name="packagePath"> Path for embedded child package. Type: string (or Expression with resultType string). </param>
        /// <param name="packageContent"> Content for embedded child package. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="packagePath"/> or <paramref name="packageContent"/> is null. </exception>
        public SsisChildPackage(object packagePath, object packageContent)
        {
            Argument.AssertNotNull(packagePath, nameof(packagePath));
            Argument.AssertNotNull(packageContent, nameof(packageContent));

            PackagePath = packagePath;
            PackageContent = packageContent;
        }

        /// <summary> Initializes a new instance of <see cref="SsisChildPackage"/>. </summary>
        /// <param name="packagePath"> Path for embedded child package. Type: string (or Expression with resultType string). </param>
        /// <param name="packageName"> Name for embedded child package. </param>
        /// <param name="packageContent"> Content for embedded child package. Type: string (or Expression with resultType string). </param>
        /// <param name="packageLastModifiedDate"> Last modified date for embedded child package. </param>
        internal SsisChildPackage(object packagePath, string packageName, object packageContent, string packageLastModifiedDate)
        {
            PackagePath = packagePath;
            PackageName = packageName;
            PackageContent = packageContent;
            PackageLastModifiedDate = packageLastModifiedDate;
        }

        /// <summary> Path for embedded child package. Type: string (or Expression with resultType string). </summary>
        public object PackagePath { get; set; }
        /// <summary> Name for embedded child package. </summary>
        public string PackageName { get; set; }
        /// <summary> Content for embedded child package. Type: string (or Expression with resultType string). </summary>
        public object PackageContent { get; set; }
        /// <summary> Last modified date for embedded child package. </summary>
        public string PackageLastModifiedDate { get; set; }
    }
}
