// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Square Service linked service. </summary>
    public partial class SquareLinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="SquareLinkedService"/>. </summary>
        /// <param name="host"> The URL of the Square instance. (i.e. mystore.mysquare.com). </param>
        /// <param name="clientId"> The client ID associated with your Square application. </param>
        /// <param name="redirectUri"> The redirect URL assigned in the Square application dashboard. (i.e. http://localhost:2500). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="host"/>, <paramref name="clientId"/> or <paramref name="redirectUri"/> is null. </exception>
        public SquareLinkedService(object host, object clientId, object redirectUri)
        {
            Argument.AssertNotNull(host, nameof(host));
            Argument.AssertNotNull(clientId, nameof(clientId));
            Argument.AssertNotNull(redirectUri, nameof(redirectUri));

            Host = host;
            ClientId = clientId;
            RedirectUri = redirectUri;
            Type = "Square";
        }

        /// <summary> Initializes a new instance of <see cref="SquareLinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="connectionProperties"> Properties used to connect to Square. It is mutually exclusive with any other properties in the linked service. Type: object. </param>
        /// <param name="host"> The URL of the Square instance. (i.e. mystore.mysquare.com). </param>
        /// <param name="clientId"> The client ID associated with your Square application. </param>
        /// <param name="clientSecret">
        /// The client secret associated with your Square application.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="redirectUri"> The redirect URL assigned in the Square application dashboard. (i.e. http://localhost:2500). </param>
        /// <param name="useEncryptedEndpoints"> Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. </param>
        /// <param name="useHostVerification"> Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. </param>
        /// <param name="usePeerVerification"> Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </param>
        internal SquareLinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, object connectionProperties, object host, object clientId, SecretBase clientSecret, object redirectUri, object useEncryptedEndpoints, object useHostVerification, object usePeerVerification, object encryptedCredential) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            ConnectionProperties = connectionProperties;
            Host = host;
            ClientId = clientId;
            ClientSecret = clientSecret;
            RedirectUri = redirectUri;
            UseEncryptedEndpoints = useEncryptedEndpoints;
            UseHostVerification = useHostVerification;
            UsePeerVerification = usePeerVerification;
            EncryptedCredential = encryptedCredential;
            Type = type ?? "Square";
        }

        /// <summary> Properties used to connect to Square. It is mutually exclusive with any other properties in the linked service. Type: object. </summary>
        public object ConnectionProperties { get; set; }
        /// <summary> The URL of the Square instance. (i.e. mystore.mysquare.com). </summary>
        public object Host { get; set; }
        /// <summary> The client ID associated with your Square application. </summary>
        public object ClientId { get; set; }
        /// <summary>
        /// The client secret associated with your Square application.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase ClientSecret { get; set; }
        /// <summary> The redirect URL assigned in the Square application dashboard. (i.e. http://localhost:2500). </summary>
        public object RedirectUri { get; set; }
        /// <summary> Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. </summary>
        public object UseEncryptedEndpoints { get; set; }
        /// <summary> Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. </summary>
        public object UseHostVerification { get; set; }
        /// <summary> Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. </summary>
        public object UsePeerVerification { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </summary>
        public object EncryptedCredential { get; set; }
    }
}
