// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(SqlScriptsListResponseConverter))]
    internal partial class SqlScriptsListResponse
    {
        internal static SqlScriptsListResponse DeserializeSqlScriptsListResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SqlScriptResource> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<SqlScriptResource> array = new List<SqlScriptResource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SqlScriptResource.DeserializeSqlScriptResource(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new SqlScriptsListResponse(value, nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SqlScriptsListResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSqlScriptsListResponse(document.RootElement);
        }

        internal partial class SqlScriptsListResponseConverter : JsonConverter<SqlScriptsListResponse>
        {
            public override void Write(Utf8JsonWriter writer, SqlScriptsListResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override SqlScriptsListResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeSqlScriptsListResponse(document.RootElement);
            }
        }
    }
}
