// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The metadata of the SQL script. </summary>
    public partial class SqlScriptMetadata
    {
        /// <summary> Initializes a new instance of <see cref="SqlScriptMetadata"/>. </summary>
        public SqlScriptMetadata()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlScriptMetadata"/>. </summary>
        /// <param name="language"> The language of the SQL script. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal SqlScriptMetadata(string language, IDictionary<string, object> additionalProperties)
        {
            Language = language;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The language of the SQL script. </summary>
        public string Language { get; set; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
