// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> SQL script. </summary>
    public partial class SqlScript
    {
        /// <summary> Initializes a new instance of <see cref="SqlScript"/>. </summary>
        /// <param name="content"> The content of the SQL script. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public SqlScript(SqlScriptContent content)
        {
            Argument.AssertNotNull(content, nameof(content));

            Content = content;
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlScript"/>. </summary>
        /// <param name="description"> The description of the SQL script. </param>
        /// <param name="type"> The type of the SQL script. </param>
        /// <param name="content"> The content of the SQL script. </param>
        /// <param name="folder"> The folder that this SQL script is in. If not specified, this SQL script will appear at the root level. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal SqlScript(string description, SqlScriptType? type, SqlScriptContent content, SqlScriptFolder folder, IDictionary<string, object> additionalProperties)
        {
            Description = description;
            Type = type;
            Content = content;
            Folder = folder;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The description of the SQL script. </summary>
        public string Description { get; set; }
        /// <summary> The type of the SQL script. </summary>
        public SqlScriptType? Type { get; set; }
        /// <summary> The content of the SQL script. </summary>
        public SqlScriptContent Content { get; set; }
        /// <summary> The folder that this SQL script is in. If not specified, this SQL script will appear at the root level. </summary>
        public SqlScriptFolder Folder { get; set; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
