// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The partition mechanism that will be used for Sql read in parallel. </summary>
    internal readonly partial struct SqlPartitionOption : IEquatable<SqlPartitionOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlPartitionOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlPartitionOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PhysicalPartitionsOfTableValue = "PhysicalPartitionsOfTable";
        private const string DynamicRangeValue = "DynamicRange";

        /// <summary> None. </summary>
        public static SqlPartitionOption None { get; } = new SqlPartitionOption(NoneValue);
        /// <summary> PhysicalPartitionsOfTable. </summary>
        public static SqlPartitionOption PhysicalPartitionsOfTable { get; } = new SqlPartitionOption(PhysicalPartitionsOfTableValue);
        /// <summary> DynamicRange. </summary>
        public static SqlPartitionOption DynamicRange { get; } = new SqlPartitionOption(DynamicRangeValue);
        /// <summary> Determines if two <see cref="SqlPartitionOption"/> values are the same. </summary>
        public static bool operator ==(SqlPartitionOption left, SqlPartitionOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlPartitionOption"/> values are not the same. </summary>
        public static bool operator !=(SqlPartitionOption left, SqlPartitionOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlPartitionOption"/>. </summary>
        public static implicit operator SqlPartitionOption(string value) => new SqlPartitionOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlPartitionOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlPartitionOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
