// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Sql always encrypted AKV authentication type. Type: string. </summary>
    public readonly partial struct SqlAlwaysEncryptedAkvAuthType : IEquatable<SqlAlwaysEncryptedAkvAuthType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlAlwaysEncryptedAkvAuthType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlAlwaysEncryptedAkvAuthType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServicePrincipalValue = "ServicePrincipal";
        private const string ManagedIdentityValue = "ManagedIdentity";
        private const string UserAssignedManagedIdentityValue = "UserAssignedManagedIdentity";

        /// <summary> ServicePrincipal. </summary>
        public static SqlAlwaysEncryptedAkvAuthType ServicePrincipal { get; } = new SqlAlwaysEncryptedAkvAuthType(ServicePrincipalValue);
        /// <summary> ManagedIdentity. </summary>
        public static SqlAlwaysEncryptedAkvAuthType ManagedIdentity { get; } = new SqlAlwaysEncryptedAkvAuthType(ManagedIdentityValue);
        /// <summary> UserAssignedManagedIdentity. </summary>
        public static SqlAlwaysEncryptedAkvAuthType UserAssignedManagedIdentity { get; } = new SqlAlwaysEncryptedAkvAuthType(UserAssignedManagedIdentityValue);
        /// <summary> Determines if two <see cref="SqlAlwaysEncryptedAkvAuthType"/> values are the same. </summary>
        public static bool operator ==(SqlAlwaysEncryptedAkvAuthType left, SqlAlwaysEncryptedAkvAuthType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlAlwaysEncryptedAkvAuthType"/> values are not the same. </summary>
        public static bool operator !=(SqlAlwaysEncryptedAkvAuthType left, SqlAlwaysEncryptedAkvAuthType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlAlwaysEncryptedAkvAuthType"/>. </summary>
        public static implicit operator SqlAlwaysEncryptedAkvAuthType(string value) => new SqlAlwaysEncryptedAkvAuthType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlAlwaysEncryptedAkvAuthType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlAlwaysEncryptedAkvAuthType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
