// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(SparkServiceErrorConverter))]
    public partial class SparkServiceError
    {
        internal static SparkServiceError DeserializeSparkServiceError(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string message = default;
            string errorCode = default;
            SparkErrorSource? source = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("message"u8))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorCode"u8))
                {
                    errorCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("source"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    source = new SparkErrorSource(property.Value.GetString());
                    continue;
                }
            }
            return new SparkServiceError(message, errorCode, source);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SparkServiceError FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSparkServiceError(document.RootElement);
        }

        internal partial class SparkServiceErrorConverter : JsonConverter<SparkServiceError>
        {
            public override void Write(Utf8JsonWriter writer, SparkServiceError model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override SparkServiceError Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeSparkServiceError(document.RootElement);
            }
        }
    }
}
