// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The SparkScheduler. </summary>
    public partial class SparkScheduler
    {
        /// <summary> Initializes a new instance of <see cref="SparkScheduler"/>. </summary>
        internal SparkScheduler()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SparkScheduler"/>. </summary>
        /// <param name="submittedAt"></param>
        /// <param name="scheduledAt"></param>
        /// <param name="endedAt"></param>
        /// <param name="cancellationRequestedAt"></param>
        /// <param name="currentState"></param>
        internal SparkScheduler(DateTimeOffset? submittedAt, DateTimeOffset? scheduledAt, DateTimeOffset? endedAt, DateTimeOffset? cancellationRequestedAt, SchedulerCurrentState? currentState)
        {
            SubmittedAt = submittedAt;
            ScheduledAt = scheduledAt;
            EndedAt = endedAt;
            CancellationRequestedAt = cancellationRequestedAt;
            CurrentState = currentState;
        }

        /// <summary> Gets the submitted at. </summary>
        public DateTimeOffset? SubmittedAt { get; }
        /// <summary> Gets the scheduled at. </summary>
        public DateTimeOffset? ScheduledAt { get; }
        /// <summary> Gets the ended at. </summary>
        public DateTimeOffset? EndedAt { get; }
        /// <summary> Gets the cancellation requested at. </summary>
        public DateTimeOffset? CancellationRequestedAt { get; }
        /// <summary> Gets the current state. </summary>
        public SchedulerCurrentState? CurrentState { get; }
    }
}
