// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(SparkJobDefinitionsListResponseConverter))]
    internal partial class SparkJobDefinitionsListResponse
    {
        internal static SparkJobDefinitionsListResponse DeserializeSparkJobDefinitionsListResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SparkJobDefinitionResource> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<SparkJobDefinitionResource> array = new List<SparkJobDefinitionResource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SparkJobDefinitionResource.DeserializeSparkJobDefinitionResource(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new SparkJobDefinitionsListResponse(value, nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SparkJobDefinitionsListResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSparkJobDefinitionsListResponse(document.RootElement);
        }

        internal partial class SparkJobDefinitionsListResponseConverter : JsonConverter<SparkJobDefinitionsListResponse>
        {
            public override void Write(Utf8JsonWriter writer, SparkJobDefinitionsListResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override SparkJobDefinitionsListResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeSparkJobDefinitionsListResponse(document.RootElement);
            }
        }
    }
}
