// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Spark job definition resource type. </summary>
    public partial class SparkJobDefinitionResource : SubResource
    {
        /// <summary> Initializes a new instance of <see cref="SparkJobDefinitionResource"/>. </summary>
        /// <param name="properties"> Properties of spark job definition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public SparkJobDefinitionResource(SparkJobDefinition properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="SparkJobDefinitionResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of spark job definition. </param>
        internal SparkJobDefinitionResource(string id, string name, string type, string etag, SparkJobDefinition properties) : base(id, name, type, etag)
        {
            Properties = properties;
        }

        /// <summary> Properties of spark job definition. </summary>
        public SparkJobDefinition Properties { get; set; }
    }
}
