// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The SparkErrorSource. </summary>
    public readonly partial struct SparkErrorSource : IEquatable<SparkErrorSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SparkErrorSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SparkErrorSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemValue = "System";
        private const string UserValue = "User";
        private const string UnknownValue = "Unknown";
        private const string DependencyValue = "Dependency";

        /// <summary> System. </summary>
        public static SparkErrorSource System { get; } = new SparkErrorSource(SystemValue);
        /// <summary> User. </summary>
        public static SparkErrorSource User { get; } = new SparkErrorSource(UserValue);
        /// <summary> Unknown. </summary>
        public static SparkErrorSource Unknown { get; } = new SparkErrorSource(UnknownValue);
        /// <summary> Dependency. </summary>
        public static SparkErrorSource Dependency { get; } = new SparkErrorSource(DependencyValue);
        /// <summary> Determines if two <see cref="SparkErrorSource"/> values are the same. </summary>
        public static bool operator ==(SparkErrorSource left, SparkErrorSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SparkErrorSource"/> values are not the same. </summary>
        public static bool operator !=(SparkErrorSource left, SparkErrorSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SparkErrorSource"/>. </summary>
        public static implicit operator SparkErrorSource(string value) => new SparkErrorSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SparkErrorSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SparkErrorSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
