// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Snowflake linked service. </summary>
    public partial class SnowflakeV2LinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="SnowflakeV2LinkedService"/>. </summary>
        /// <param name="accountIdentifier"> The account identifier of your Snowflake account, e.g. xy12345.east-us-2.azure. </param>
        /// <param name="database"> The name of the Snowflake database. </param>
        /// <param name="warehouse"> The name of the Snowflake warehouse. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="accountIdentifier"/>, <paramref name="database"/> or <paramref name="warehouse"/> is null. </exception>
        public SnowflakeV2LinkedService(object accountIdentifier, object database, object warehouse)
        {
            Argument.AssertNotNull(accountIdentifier, nameof(accountIdentifier));
            Argument.AssertNotNull(database, nameof(database));
            Argument.AssertNotNull(warehouse, nameof(warehouse));

            AccountIdentifier = accountIdentifier;
            Database = database;
            Warehouse = warehouse;
            Type = "SnowflakeV2";
        }

        /// <summary> Initializes a new instance of <see cref="SnowflakeV2LinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="accountIdentifier"> The account identifier of your Snowflake account, e.g. xy12345.east-us-2.azure. </param>
        /// <param name="user"> The name of the Snowflake user. </param>
        /// <param name="password">
        /// The Azure key vault secret reference of password in connection string.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="database"> The name of the Snowflake database. </param>
        /// <param name="warehouse"> The name of the Snowflake warehouse. </param>
        /// <param name="authenticationType"> The type used for authentication. Type: string. </param>
        /// <param name="clientId"> The client ID of the application registered in Azure Active Directory for AADServicePrincipal authentication. </param>
        /// <param name="clientSecret">
        /// The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="tenantId"> The tenant ID of the application registered in Azure Active Directory for AADServicePrincipal authentication. </param>
        /// <param name="scope"> The scope of the application registered in Azure Active Directory for AADServicePrincipal authentication. </param>
        /// <param name="privateKey">
        /// The Azure key vault secret reference of privateKey for KeyPair auth.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="privateKeyPassphrase">
        /// The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </param>
        internal SnowflakeV2LinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, object accountIdentifier, object user, SecretBase password, object database, object warehouse, SnowflakeAuthenticationType? authenticationType, object clientId, SecretBase clientSecret, object tenantId, object scope, SecretBase privateKey, SecretBase privateKeyPassphrase, string encryptedCredential) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            AccountIdentifier = accountIdentifier;
            User = user;
            Password = password;
            Database = database;
            Warehouse = warehouse;
            AuthenticationType = authenticationType;
            ClientId = clientId;
            ClientSecret = clientSecret;
            TenantId = tenantId;
            Scope = scope;
            PrivateKey = privateKey;
            PrivateKeyPassphrase = privateKeyPassphrase;
            EncryptedCredential = encryptedCredential;
            Type = type ?? "SnowflakeV2";
        }

        /// <summary> The account identifier of your Snowflake account, e.g. xy12345.east-us-2.azure. </summary>
        public object AccountIdentifier { get; set; }
        /// <summary> The name of the Snowflake user. </summary>
        public object User { get; set; }
        /// <summary>
        /// The Azure key vault secret reference of password in connection string.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase Password { get; set; }
        /// <summary> The name of the Snowflake database. </summary>
        public object Database { get; set; }
        /// <summary> The name of the Snowflake warehouse. </summary>
        public object Warehouse { get; set; }
        /// <summary> The type used for authentication. Type: string. </summary>
        public SnowflakeAuthenticationType? AuthenticationType { get; set; }
        /// <summary> The client ID of the application registered in Azure Active Directory for AADServicePrincipal authentication. </summary>
        public object ClientId { get; set; }
        /// <summary>
        /// The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase ClientSecret { get; set; }
        /// <summary> The tenant ID of the application registered in Azure Active Directory for AADServicePrincipal authentication. </summary>
        public object TenantId { get; set; }
        /// <summary> The scope of the application registered in Azure Active Directory for AADServicePrincipal authentication. </summary>
        public object Scope { get; set; }
        /// <summary>
        /// The Azure key vault secret reference of privateKey for KeyPair auth.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase PrivateKey { get; set; }
        /// <summary>
        /// The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase PrivateKeyPassphrase { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </summary>
        public string EncryptedCredential { get; set; }
    }
}
