// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The authentication type to use. </summary>
    internal readonly partial struct ServiceNowV2AuthenticationType : IEquatable<ServiceNowV2AuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceNowV2AuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceNowV2AuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string OAuth2Value = "OAuth2";

        /// <summary> Basic. </summary>
        public static ServiceNowV2AuthenticationType Basic { get; } = new ServiceNowV2AuthenticationType(BasicValue);
        /// <summary> OAuth2. </summary>
        public static ServiceNowV2AuthenticationType OAuth2 { get; } = new ServiceNowV2AuthenticationType(OAuth2Value);
        /// <summary> Determines if two <see cref="ServiceNowV2AuthenticationType"/> values are the same. </summary>
        public static bool operator ==(ServiceNowV2AuthenticationType left, ServiceNowV2AuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceNowV2AuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(ServiceNowV2AuthenticationType left, ServiceNowV2AuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceNowV2AuthenticationType"/>. </summary>
        public static implicit operator ServiceNowV2AuthenticationType(string value) => new ServiceNowV2AuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceNowV2AuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceNowV2AuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
