// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Self-hosted integration runtime. </summary>
    public partial class SelfHostedIntegrationRuntime : IntegrationRuntime
    {
        /// <summary> Initializes a new instance of <see cref="SelfHostedIntegrationRuntime"/>. </summary>
        public SelfHostedIntegrationRuntime()
        {
            Type = IntegrationRuntimeType.SelfHosted;
        }

        /// <summary> Initializes a new instance of <see cref="SelfHostedIntegrationRuntime"/>. </summary>
        /// <param name="type"> Type of integration runtime. </param>
        /// <param name="description"> Integration runtime description. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="linkedInfo">
        /// Linked integration runtime type from data factory
        /// Please note <see cref="LinkedIntegrationRuntimeType"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LinkedIntegrationRuntimeKeyAuthorization"/> and <see cref="LinkedIntegrationRuntimeRbacAuthorization"/>.
        /// </param>
        internal SelfHostedIntegrationRuntime(IntegrationRuntimeType type, string description, IDictionary<string, object> additionalProperties, LinkedIntegrationRuntimeType linkedInfo) : base(type, description, additionalProperties)
        {
            LinkedInfo = linkedInfo;
            Type = type;
        }

        /// <summary>
        /// Linked integration runtime type from data factory
        /// Please note <see cref="LinkedIntegrationRuntimeType"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LinkedIntegrationRuntimeKeyAuthorization"/> and <see cref="LinkedIntegrationRuntimeRbacAuthorization"/>.
        /// </summary>
        public LinkedIntegrationRuntimeType LinkedInfo { get; set; }
    }
}
