// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Execution policy for an activity that supports secure input and output. </summary>
    public partial class SecureInputOutputPolicy
    {
        /// <summary> Initializes a new instance of <see cref="SecureInputOutputPolicy"/>. </summary>
        public SecureInputOutputPolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecureInputOutputPolicy"/>. </summary>
        /// <param name="secureInput"> When set to true, Input from activity is considered as secure and will not be logged to monitoring. </param>
        /// <param name="secureOutput"> When set to true, Output from activity is considered as secure and will not be logged to monitoring. </param>
        internal SecureInputOutputPolicy(bool? secureInput, bool? secureOutput)
        {
            SecureInput = secureInput;
            SecureOutput = secureOutput;
        }

        /// <summary> When set to true, Input from activity is considered as secure and will not be logged to monitoring. </summary>
        public bool? SecureInput { get; set; }
        /// <summary> When set to true, Output from activity is considered as secure and will not be logged to monitoring. </summary>
        public bool? SecureOutput { get; set; }
    }
}
